/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.macros;

import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvVarOperationProcessor;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacro;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacro;
import org.eclipse.cdt.managedbuilder.macros.IBuildMacroSupplier;
import org.eclipse.core.resources.IWorkspace;

public class EnvironmentMacroSupplier
implements IBuildMacroSupplier {
    private static EnvironmentMacroSupplier fInstance;
    private EnvironmentVariableProvider fEnvironmentProvider;

    protected EnvironmentMacroSupplier() {
        this((EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider());
    }

    public EnvironmentMacroSupplier(EnvironmentVariableProvider varProvider) {
        this.fEnvironmentProvider = varProvider;
    }

    public IBuildMacro createBuildMacro(IBuildEnvironmentVariable var) {
        if (var != null) {
            return new EnvVarMacro(var);
        }
        return null;
    }

    public static EnvironmentMacroSupplier getInstance() {
        if (fInstance == null) {
            fInstance = new EnvironmentMacroSupplier();
        }
        return fInstance;
    }

    public IBuildMacro getMacro(String macroName, int contextType, Object contextData) {
        if (macroName == null || "".equals(macroName)) {
            return null;
        }
        IBuildEnvironmentVariable var = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof IConfiguration)) break;
                var = this.fEnvironmentProvider.getVariable(macroName, this.fEnvironmentProvider.getContextInfo(contextData), false);
                break;
            }
            case 4: {
                if (!(contextData instanceof IManagedProject)) break;
                var = this.fEnvironmentProvider.getVariable(macroName, this.fEnvironmentProvider.getContextInfo(contextData), false);
                break;
            }
            case 5: {
                if (!(contextData instanceof IWorkspace)) break;
                var = this.fEnvironmentProvider.getVariable(macroName, this.fEnvironmentProvider.getContextInfo(contextData), false);
                break;
            }
            case 7: {
                if (contextData != null) break;
                var = this.fEnvironmentProvider.getVariable(macroName, this.fEnvironmentProvider.getContextInfo(contextData), false);
            }
        }
        if (var != null && var.getOperation() != 2) {
            return new EnvVarMacro(var);
        }
        return null;
    }

    public IBuildMacro[] getMacros(int contextType, Object contextData) {
        IBuildEnvironmentVariable[] vars = null;
        switch (contextType) {
            case 3: {
                if (!(contextData instanceof IConfiguration)) break;
                vars = this.fEnvironmentProvider.getVariables(this.fEnvironmentProvider.getContextInfo(contextData), false).toArray(false);
                break;
            }
            case 4: {
                if (!(contextData instanceof IManagedProject)) break;
                vars = this.fEnvironmentProvider.getVariables(this.fEnvironmentProvider.getContextInfo(contextData), false).toArray(false);
                break;
            }
            case 5: {
                if (!(contextData instanceof IWorkspace)) break;
                vars = this.fEnvironmentProvider.getVariables(this.fEnvironmentProvider.getContextInfo(contextData), false).toArray(false);
                break;
            }
            case 7: {
                if (contextData != null) break;
                vars = this.fEnvironmentProvider.getVariables(this.fEnvironmentProvider.getContextInfo(contextData), false).toArray(false);
            }
        }
        if (vars != null) {
            IBuildMacro[] macros = new EnvVarMacro[vars.length];
            int i = 0;
            while (i < macros.length) {
                macros[i] = new EnvVarMacro(vars[i]);
                ++i;
            }
            return macros;
        }
        return null;
    }

    public EnvironmentVariableProvider getEnvironmentVariableProvider() {
        return this.fEnvironmentProvider;
    }

    public class EnvVarMacro
    extends BuildMacro {
        private IBuildEnvironmentVariable fVariable;

        private EnvVarMacro(IBuildEnvironmentVariable var) {
            this.fName = var.getName();
            this.fVariable = var;
        }

        private void loadValue(IBuildEnvironmentVariable var) {
            String value;
            String delimiter = var.getDelimiter();
            String string = value = var.getOperation() != 2 ? var.getValue() : null;
            if (delimiter != null && !"".equals(delimiter)) {
                this.fType = 2;
                if (value != null) {
                    List list = EnvVarOperationProcessor.convertToList(value, delimiter);
                    this.fStringListValue = list.toArray(new String[list.size()]);
                } else {
                    this.fStringListValue = null;
                }
            } else {
                this.fType = 1;
                this.fStringValue = value;
            }
        }

        public int getMacroValueType() {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getMacroValueType();
        }

        public String getStringValue() throws BuildMacroException {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getStringValue();
        }

        public String[] getStringListValue() throws BuildMacroException {
            if (this.fVariable != null) {
                this.loadValue(this.fVariable);
                this.fVariable = null;
            }
            return super.getStringListValue();
        }
    }
}

