/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.corext.refactoring;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IOpenable;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;

public class ResourceUtil {
    private ResourceUtil() {
    }

    public static IFile[] getFiles(ITranslationUnit[] cus) {
        ArrayList<IResource> files = new ArrayList<IResource>(cus.length);
        int i = 0;
        while (i < cus.length) {
            IResource resource = ResourceUtil.getResource(cus[i]);
            if (resource.getType() == 1) {
                files.add(resource);
            }
            ++i;
        }
        return files.toArray(new IFile[files.size()]);
    }

    public static IFile getFile(ITranslationUnit cu) {
        IResource resource = ResourceUtil.getResource(cu);
        if (resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    public static IResource getResource(ITranslationUnit cu) {
        return cu.getResource();
    }

    public static IResource getResource(IMember member) {
        return ResourceUtil.getResource(member.getTranslationUnit());
    }

    public static IResource getResource(Object o) {
        if (o instanceof IResource) {
            return (IResource)o;
        }
        if (o instanceof ICElement) {
            return ResourceUtil.getResource((ICElement)o);
        }
        return null;
    }

    private static IResource getResource(ICElement element) {
        if (element.getElementType() == 60) {
            return ResourceUtil.getResource((ITranslationUnit)element);
        }
        if (element instanceof IOpenable) {
            return element.getResource();
        }
        return null;
    }
}

