/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.ui.search.LRUWorkingSets;
import org.eclipse.core.resources.IMarker;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;

public class CSearchUtil {
    public static int LRU_WORKINGSET_LIST_SIZE = 3;
    private static LRUWorkingSets workingSetsCache;

    public static void updateLRUWorkingSets(IWorkingSet[] workingSets) {
        if (workingSets == null || workingSets.length < 1) {
            return;
        }
        CSearchUtil.getLRUWorkingSets().add(workingSets);
    }

    public static LRUWorkingSets getLRUWorkingSets() {
        if (workingSetsCache == null) {
            workingSetsCache = new LRUWorkingSets(LRU_WORKINGSET_LIST_SIZE);
        }
        return workingSetsCache;
    }

    public static void warnIfBinaryConstant(ICElement element, Shell shell) {
    }

    public static String toString(IWorkingSet[] workingSets) {
        if (workingSets != null & workingSets.length > 0) {
            String string = new String();
            int i = 0;
            while (i < workingSets.length) {
                if (i > 0) {
                    string = String.valueOf(string) + ", ";
                }
                string = String.valueOf(string) + workingSets[i].getName();
                ++i;
            }
            return string;
        }
        return null;
    }

    public static ICElement getCElement(IMarker marker) {
        return null;
    }

    public static ICSearchConstants.SearchFor getSearchForFromElement(ICElement element) {
        if (element == null) {
            return null;
        }
        ICSearchConstants.SearchFor searchFor = null;
        String pattern = element.getElementName();
        boolean forceMethod = pattern.indexOf("::") != -1;
        switch (element.getElementType()) {
            case 73: 
            case 74: 
            case 89: {
                if (forceMethod) {
                    searchFor = ICSearchConstants.METHOD;
                    break;
                }
                searchFor = ICSearchConstants.FUNCTION;
                break;
            }
            case 76: {
                searchFor = ICSearchConstants.VAR;
                break;
            }
            case 65: 
            case 67: 
            case 83: {
                searchFor = ICSearchConstants.CLASS_STRUCT;
                break;
            }
            case 69: {
                searchFor = ICSearchConstants.UNION;
                break;
            }
            case 81: {
                searchFor = ICSearchConstants.ENUMTOR;
                break;
            }
            case 72: {
                searchFor = ICSearchConstants.FIELD;
                break;
            }
            case 70: 
            case 71: 
            case 91: {
                searchFor = ICSearchConstants.METHOD;
                break;
            }
            case 61: {
                searchFor = ICSearchConstants.NAMESPACE;
                break;
            }
            case 63: {
                searchFor = ICSearchConstants.ENUM;
                break;
            }
            default: {
                searchFor = ICSearchConstants.UNKNOWN_SEARCH_FOR;
            }
        }
        return searchFor;
    }

    public static ICSearchConstants.SearchFor getSearchForFromNode(IASTOffsetableNamedElement node) {
        ICSearchConstants.SearchFor searchFor = null;
        if (node instanceof IASTClassSpecifier) {
            IASTClassSpecifier tempNode = (IASTClassSpecifier)node;
            if (tempNode.getClassKind().equals(ASTClassKind.CLASS)) {
                searchFor = ICSearchConstants.CLASS;
            } else if (tempNode.getClassKind().equals(ASTClassKind.STRUCT)) {
                searchFor = ICSearchConstants.STRUCT;
            } else if (tempNode.getClassKind().equals(ASTClassKind.UNION)) {
                searchFor = ICSearchConstants.UNION;
            }
        } else if (node instanceof IASTMethod) {
            searchFor = ICSearchConstants.METHOD;
        } else if (node instanceof IASTFunction) {
            searchFor = ICSearchConstants.FUNCTION;
        } else if (node instanceof IASTField) {
            searchFor = ICSearchConstants.FIELD;
        } else if (node instanceof IASTVariable) {
            searchFor = ICSearchConstants.VAR;
        } else if (node instanceof IASTEnumerationSpecifier) {
            searchFor = ICSearchConstants.ENUM;
        } else if (node instanceof IASTNamespaceDefinition) {
            searchFor = ICSearchConstants.NAMESPACE;
        } else if (node instanceof IASTTypedefDeclaration) {
            searchFor = ICSearchConstants.TYPEDEF;
        } else if (node instanceof IASTEnumerator) {
            searchFor = ICSearchConstants.ENUMTOR;
        }
        return searchFor;
    }
}

