/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.dom.CDOM;
import org.eclipse.cdt.core.dom.IASTServiceProvider;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.ILabel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.search.DOMSearchUtil;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.model.Util;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.DOMQuery;
import org.eclipse.cdt.internal.ui.search.actions.SelectionParseAction;
import org.eclipse.cdt.internal.ui.util.ExternalEditorInput;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IWorkbenchSite;

public abstract class FindAction
extends SelectionParseAction {
    public FindAction(CEditor editor) {
        super(editor);
    }

    public FindAction(IWorkbenchSite site) {
        super(site);
    }

    public CSearchQuery createDOMSearchQueryForName(IASTName name, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String searchPattern) {
        return new DOMQuery(DOMSearchUtil.getSearchPattern((IASTName)name), name, limitTo, scope, searchPattern);
    }

    public CSearchQuery createSearchQueryForName(IASTName name, ICSearchConstants.LimitTo limitTo, ICSearchScope scope, String searchPattern) {
        return this.createDOMSearchQueryForName(name, limitTo, scope, searchPattern);
    }

    public void run() {
        ISelection sel = this.getSelection();
        if (sel instanceof IStructuredSelection) {
            Object obj = ((IStructuredSelection)sel).getFirstElement();
            if (obj instanceof ISourceReference && this.fSite.getSelectionProvider() instanceof ProblemTreeViewer) {
                try {
                    this.fEditor = ((ProblemTreeViewer)this.fSite.getSelectionProvider()).getEditor();
                    if (this.fEditor != null) {
                        IDocument doc = this.fEditor.getDocumentProvider().getDocument((Object)this.fEditor.getEditorInput());
                        ISourceReference ref = (ISourceReference)obj;
                        TextSelection selection = new TextSelection(doc, ref.getSourceRange().getIdStartPos(), ref.getSourceRange().getIdLength());
                        this.run((ITextSelection)selection);
                        return;
                    }
                }
                catch (Exception exception) {}
            }
            this.run((IStructuredSelection)sel);
        } else if (sel instanceof ITextSelection) {
            this.run((ITextSelection)sel);
        }
    }

    public void run(IStructuredSelection sel) {
        Object obj = sel.getFirstElement();
        if (obj == null || !(obj instanceof ICElement)) {
            this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
            return;
        }
        this.clearStatusLine();
        ICElement element = (ICElement)obj;
        CSearchQuery job = this.createSearchQuery(this.getFullyQualifiedName(element), CSearchUtil.getSearchForFromElement(element));
        if (job == null) {
            return;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)job);
    }

    protected CSearchQuery createSearchQuery(String pattern, ICSearchConstants.SearchFor searchFor) {
        CSearchQuery op = null;
        ICSearchScope scope = this.getScope();
        if (scope == null) {
            return null;
        }
        String scopeDescription = this.getScopeDescription();
        LinkedList<ICSearchConstants.SearchFor> search = new LinkedList<ICSearchConstants.SearchFor>();
        search.add(searchFor);
        ICSearchConstants.LimitTo limitTo = this.getLimitTo();
        op = new CSearchQuery(CCorePlugin.getWorkspace(), pattern, true, search, limitTo, scope, scopeDescription);
        return op;
    }

    public void run(ITextSelection sel) {
        ParserLanguage lang;
        IASTNode foundNode;
        SelectionParseAction.SelSearchNode selNode;
        block17: {
            if (sel == null) {
                return;
            }
            selNode = this.getSelection(sel);
            foundNode = null;
            IASTTranslationUnit tu = null;
            lang = null;
            String file = null;
            ParseWithProgress runnable = new ParseWithProgress();
            ProgressMonitorDialog progressMonitor = new ProgressMonitorDialog(this.fEditor.getSite().getShell());
            try {
                progressMonitor.run(true, true, (IRunnableWithProgress)runnable);
                tu = runnable.getTu();
                file = runnable.getFile();
                lang = runnable.getLang();
            }
            catch (InvocationTargetException invocationTargetException) {
                this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
                return;
            }
            catch (InterruptedException interruptedException) {
                this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
                return;
            }
            try {
                foundNode = tu.selectNodeForLocation(file, selNode.selStart, selNode.selEnd - selNode.selStart);
            }
            catch (ParseError parseError) {
            }
            catch (Exception exception) {
            }
            catch (VirtualMachineError vmErr) {
                if (!(vmErr instanceof OutOfMemoryError)) break block17;
                Util.log(null, (String)("Selection Search Out Of Memory error: " + vmErr.getMessage() + " on File: " + file), (ICLogConstants.LogConst)ICLogConstants.CDT);
            }
        }
        IASTName foundName = null;
        if (foundNode instanceof IASTName) {
            foundName = (IASTName)foundNode;
        } else {
            Object collector = null;
            collector = lang == ParserLanguage.CPP ? new DOMSearchUtil.CPPNameCollector() : new DOMSearchUtil.CNameCollector();
            if (foundNode != null) {
                foundNode.accept((ASTVisitor)collector);
                List names = null;
                names = collector instanceof DOMSearchUtil.CPPNameCollector ? collector.nameList : ((DOMSearchUtil.CNameCollector)collector).nameList;
                if (names.size() == 1) {
                    this.clearStatusLine();
                } else if (names.size() == 0) {
                    this.operationNotAvailable("CSearchOperation.noNamesSelected.message");
                    return;
                }
                foundName = (IASTName)names.get(0);
            }
        }
        if (foundName != null && foundName.resolveBinding() instanceof ILabel) {
            this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
            return;
        }
        ICSearchConstants.LimitTo limitTo = this.getLimitTo();
        ICSearchScope searchScope = null;
        searchScope = this.getScope();
        if (searchScope == null) {
            return;
        }
        CSearchQuery job = this.createSearchQueryForName(foundName, limitTo, searchScope, selNode.selText);
        if (job == null) {
            return;
        }
        NewSearchUI.activateSearchResultView();
        NewSearchUI.runQueryInBackground((ISearchQuery)job);
    }

    private String getFullyQualifiedName(ICElement element) {
        StringBuffer fullName = new StringBuffer(element.getElementName());
        while (element.getElementType() != 0) {
            if ((element = element.getParent()).getElementType() == 60 || element == null) break;
            if (element.getElementType() == 63) continue;
            fullName.insert(0, "::");
            fullName.insert(0, element.getElementName());
        }
        return fullName.toString();
    }

    protected abstract String getScopeDescription();

    protected abstract ICSearchScope getScope();

    protected abstract ICSearchConstants.LimitTo getLimitTo();

    private class ParseWithProgress
    implements IRunnableWithProgress {
        private IASTTranslationUnit tu = null;
        private String file = null;
        private ParserLanguage lang = null;

        public void run(IProgressMonitor monitor) {
            if (FindAction.this.fEditor.getEditorInput() instanceof ExternalEditorInput) {
                ExternalEditorInput input = (ExternalEditorInput)FindAction.this.fEditor.getEditorInput();
                try {
                    ITranslationUnit project = input.getTranslationUnit();
                    while (!(project instanceof ICProject) && project != null) {
                        project = project.getParent();
                    }
                    if (project instanceof ICProject) {
                        this.tu = CDOM.getInstance().getASTService().getTranslationUnit(input.getStorage(), ((ICProject)project).getProject());
                        this.lang = DOMSearchUtil.getLanguage((IPath)input.getStorage().getFullPath(), (IProject)((ICProject)project).getProject());
                    }
                }
                catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {
                    FindAction.this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
                    return;
                }
                this.file = input.getStorage().getFullPath().toOSString();
            } else {
                IFile resourceFile = null;
                resourceFile = FindAction.this.fEditor.getInputFile();
                try {
                    this.tu = CDOM.getInstance().getASTService().getTranslationUnit(resourceFile, CDOM.getInstance().getCodeReaderFactory(2));
                }
                catch (IASTServiceProvider.UnsupportedDialectException unsupportedDialectException) {
                    FindAction.this.operationNotAvailable("CSearchOperation.operationUnavailable.message");
                    return;
                }
                this.file = resourceFile.getLocation().toOSString();
                this.lang = DOMSearchUtil.getLanguageFromFile((IFile)resourceFile);
            }
        }

        public IASTTranslationUnit getTu() {
            return this.tu;
        }

        public String getFile() {
            return this.file;
        }

        public ParserLanguage getLang() {
            return this.lang;
        }
    }
}

