/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.core.browser.IWorkingCopyProvider;
import org.eclipse.cdt.core.dom.ICodeReaderFactory;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.ICodeReaderCache;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.internal.core.dom.SavedCodeReaderFactory;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;

public class PartialWorkingCopyCodeReaderFactory
implements ICodeReaderFactory {
    private final IWorkingCopyProvider provider;
    private ICodeReaderCache cache = null;

    public PartialWorkingCopyCodeReaderFactory(IWorkingCopyProvider provider) {
        this.provider = provider;
        this.cache = SavedCodeReaderFactory.getInstance().getCodeReaderCache();
    }

    public int getUniqueIdentifier() {
        return 1;
    }

    public CodeReader createCodeReaderForTranslationUnit(String path) {
        return this.checkWorkingCopyThenCache(path);
    }

    protected CodeReader checkWorkingCopyThenCache(String path) {
        char[] buffer = ParserUtil.findWorkingCopyBuffer(path, this.createWorkingCopyIterator());
        if (buffer != null) {
            return new CodeReader(path, buffer);
        }
        return this.cache.get(path);
    }

    public CodeReader createCodeReaderForInclusion(String path) {
        return this.cache.get(path);
    }

    protected Iterator createWorkingCopyIterator() {
        if (this.provider == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return Arrays.asList(this.provider.getWorkingCopies()).iterator();
    }

    public ICodeReaderCache getCodeReaderCache() {
        return this.cache;
    }
}

