/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.ctagsindexer;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.AbstractCExtension;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.ICLogConstants;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.index.ICDTIndexer;
import org.eclipse.cdt.core.index.IIndexChangeListener;
import org.eclipse.cdt.core.index.IIndexStorage;
import org.eclipse.cdt.core.index.IndexChangeEvent;
import org.eclipse.cdt.internal.core.ConsoleOutputSniffer;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndex;
import org.eclipse.cdt.internal.core.index.cindexstorage.CIndexStorage;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsAddCompilationUnitToIndex;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexAll;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexRequest;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsRemoveFromIndex;
import org.eclipse.cdt.internal.core.index.impl.IndexDelta;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.cdt.internal.core.search.processing.IIndexJob;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CTagsIndexer
extends AbstractCExtension
implements ICDTIndexer {
    public static boolean VERBOSE = false;
    public static final String CTAGS_INTERNAL = "ctags_internal";
    public static final String CTAGS_EXTERNAL = "ctags_external";
    public static final String CTAGS_PATH_DEFAULT = "ctags_path_default";
    public static final String CTAGS_PATH_SPECIFIED = "ctags_path_specified";
    protected List indexChangeListeners = Collections.synchronizedList(new ArrayList());
    public static final String INDEX_NOTIFICATION_NAME = Util.bind("indexNotificationJob");
    private CIndexStorage indexStorage = null;
    public ReadWriteMonitor storageMonitor = null;
    private IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
    private HashSet jobSet = null;

    public CTagsIndexer() {
        this.indexStorage = (CIndexStorage)this.indexManager.getIndexStorageForIndexer(this);
        this.jobSet = new HashSet();
        this.storageMonitor = new ReadWriteMonitor();
    }

    public int getIndexerFeatures() {
        return 107;
    }

    public void addRequest(IProject project, IResourceDelta delta, int kind) {
        switch (kind) {
            case 1: {
                this.indexAll(project);
                break;
            }
            case 2: {
                IFolder folder = (IFolder)delta.getResource();
                this.indexSourceFolder(project, folder);
                break;
            }
            case 4: {
                IFile file = (IFile)delta.getResource();
                this.addSource(file, project.getFullPath());
                break;
            }
            default: {
                this.indexAll(project);
            }
        }
    }

    public void indexSourceFolder(IProject project, IFolder folder) {
        final HashSet indexables = new HashSet();
        try {
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (resource instanceof IFile) {
                        indexables.add(resource);
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {}
        Iterator i = indexables.iterator();
        while (i.hasNext()) {
            this.addSource((IFile)i.next(), project.getFullPath());
        }
    }

    public void indexAll(IProject project) {
        CTagsIndexAll request = new CTagsIndexAll(project, this);
        int i = this.indexManager.getJobEnd();
        while (i > this.indexManager.getJobStart()) {
            if (((Object)request).equals(this.indexManager.getAwaitingJobAt(i))) {
                return;
            }
            --i;
        }
        this.indexManager.request(request);
    }

    public void removeRequest(IProject project, IResourceDelta delta, int kind) {
        switch (kind) {
            case 1: {
                IPath fullPath = project.getFullPath();
                if (delta.getKind() == 4) {
                    this.indexManager.discardJobs(fullPath.segment(0));
                }
                this.indexStorage.removeIndexFamily(fullPath);
                break;
            }
            case 4: {
                IFile file = (IFile)delta.getResource();
                this.remove(file.getFullPath().toString(), file.getProject().getFullPath());
            }
        }
    }

    public void indexJobFinishedNotification(IIndexJob job) {
        this.indexStorage.setNeedToSave(true);
        if (job instanceof CTagsAddCompilationUnitToIndex) {
            CTagsAddCompilationUnitToIndex tempJob = (CTagsAddCompilationUnitToIndex)job;
            this.jobSet.remove(tempJob.getResource().getLocation());
        }
    }

    public void shutdown() {
    }

    public void notifyIdle(long idlingTime) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IIndex getIndex(IPath path, boolean reuseExistingFile, boolean createIfMissing) {
        IIndex index = null;
        try {
            this.storageMonitor.enterRead();
            index = this.indexStorage.getIndex(path, reuseExistingFile, createIfMissing);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.storageMonitor.exitRead();
            return index;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadWriteMonitor getMonitorFor(IIndex index) {
        ReadWriteMonitor monitor = null;
        try {
            this.storageMonitor.enterRead();
            monitor = this.indexStorage.getMonitorForIndex();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.storageMonitor.exitRead();
            return monitor;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndex(IIndex index) throws IOException {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.saveIndex(index);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    public void request(IIndexJob indexJob) {
        this.indexManager.request(indexJob);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void aboutToUpdateIndex(IPath indexPath, Integer indexState) {
        this.storageMonitor.enterRead();
        try {
            this.indexStorage.aboutToUpdateIndex(indexPath, indexState);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.storageMonitor.exitRead();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.storageMonitor.exitRead();
            return;
        }
    }

    public boolean isIndexEnabled(IProject project) {
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void jobWasCancelled(IPath path) {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.jobWasCancelled(path);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    public void jobFinishedNotification(CTagsIndexRequest request) {
        this.indexJobFinishedNotification(request);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeIndex(IPath path) {
        try {
            this.storageMonitor.enterWrite();
            this.indexStorage.removeIndex(path);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.storageMonitor.exitWrite();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.storageMonitor.exitWrite();
            return;
        }
    }

    public void remove(String resourceName, IPath indexedContainer) {
        IProject project = CCorePlugin.getWorkspace().getRoot().getProject(indexedContainer.toString());
        if (this.isIndexEnabled(project)) {
            this.request(new CTagsRemoveFromIndex(resourceName, indexedContainer, this));
        }
    }

    public void addSource(IFile resource, IPath indexedContainers) {
        IProject project = resource.getProject();
        boolean indexEnabled = false;
        if (project != null) {
            indexEnabled = this.isIndexEnabled(project);
        } else {
            org.eclipse.cdt.internal.core.model.Util.log(null, "CTagsIndexer addSource: File has no project associated : " + resource.getName(), ICLogConstants.CDT);
        }
        if (CCorePlugin.getDefault() == null) {
            return;
        }
        if (indexEnabled) {
            CTagsAddCompilationUnitToIndex job = new CTagsAddCompilationUnitToIndex(resource, indexedContainers, this);
            if (!this.jobSet.add(resource.getLocation()) && this.indexManager.enabledState() == 1) {
                return;
            }
            if (this.indexManager.awaitingJobsCount() < CIndexStorage.MAX_FILES_IN_MEMORY && !job.initializeContents()) {
                return;
            }
            this.indexManager.request(job);
        }
    }

    public IIndexStorage getIndexStorage() {
        return this.indexStorage;
    }

    public void notifyIndexerChange(IProject project) {
        this.indexAll(project);
    }

    protected void createProblemMarker(String message, IProject project) {
        try {
            IMarker[] markers = project.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
            boolean newProblem = true;
            if (markers.length > 0) {
                IMarker tempMarker = null;
                String tempMsgString = null;
                int i = 0;
                while (i < markers.length) {
                    tempMarker = markers[i];
                    tempMsgString = (String)tempMarker.getAttribute("message");
                    if (tempMsgString.equalsIgnoreCase(message)) {
                        newProblem = false;
                        break;
                    }
                    ++i;
                }
            }
            if (newProblem) {
                IMarker marker = project.createMarker("org.eclipse.cdt.core.indexermarker");
                int start = 0;
                int end = 1;
                marker.setAttribute("message", (Object)message);
                marker.setAttribute("severity", 1);
                marker.setAttribute("charStart", start);
                marker.setAttribute("charEnd", end);
            }
        }
        catch (CoreException coreException) {}
    }

    public void indexerRemoved(IProject project) {
        this.indexManager.removeIndexerProblems((IResource)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndexChangeListener(IIndexChangeListener listener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            if (!this.indexChangeListeners.contains(listener)) {
                this.indexChangeListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIndexChangeListener(IIndexChangeListener listener) {
        List list = this.indexChangeListeners;
        synchronized (list) {
            int i = this.indexChangeListeners.indexOf(listener);
            if (i != -1) {
                this.indexChangeListeners.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(IndexDelta indexDelta) {
        final IndexChangeEvent indexEvent = new IndexChangeEvent(indexDelta);
        int i = 0;
        while (i < this.indexChangeListeners.size()) {
            IIndexChangeListener tempListener = null;
            List list = this.indexChangeListeners;
            synchronized (list) {
                tempListener = (IIndexChangeListener)this.indexChangeListeners.get(i);
            }
            final IIndexChangeListener listener = tempListener;
            long start = -1L;
            if (VERBOSE) {
                System.out.print("Listener #" + (i + 1) + "=" + listener.toString());
                start = System.currentTimeMillis();
            }
            Job job = new Job(INDEX_NOTIFICATION_NAME){

                protected IStatus run(IProgressMonitor monitor) {
                    Platform.run((ISafeRunnable)new ISafeRunnable(this, listener, indexEvent){
                        final /* synthetic */ 2 this$1;
                        private final /* synthetic */ IIndexChangeListener val$listener;
                        private final /* synthetic */ IndexChangeEvent val$indexEvent;
                        {
                            this.this$1 = var1_1;
                            this.val$listener = iIndexChangeListener;
                            this.val$indexEvent = indexChangeEvent;
                        }

                        public void handleException(Throwable exception) {
                            CCorePlugin.log(exception);
                        }

                        public void run() throws Exception {
                            this.val$listener.indexChanged(this.val$indexEvent);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            if (VERBOSE) {
                System.out.println(" -> " + (System.currentTimeMillis() - start) + "ms");
            }
            ++i;
        }
    }

    public boolean validCTagsInstalled() {
        String[] args = new String[]{"--version"};
        CommandLauncher launcher = new CommandLauncher();
        CTagLineReader parser = new CTagLineReader();
        IConsoleParser[] parsers = new IConsoleParser[]{parser};
        ConsoleOutputSniffer sniffer = new ConsoleOutputSniffer(parsers);
        OutputStream consoleOut = sniffer.getOutputStream();
        OutputStream consoleErr = sniffer.getErrorStream();
        Process p = launcher.execute((IPath)new Path("ctags"), args, new String[0], (IPath)new Path("."));
        if (p != null) {
            try {
                p.getOutputStream().close();
            }
            catch (IOException iOException) {}
            if (launcher.waitAndRead(consoleOut, consoleErr, (IProgressMonitor)new NullProgressMonitor()) != 0) {
                launcher.getErrorMessage();
            }
        } else {
            launcher.getErrorMessage();
            return false;
        }
        try {
            consoleOut.close();
            consoleErr.close();
        }
        catch (IOException iOException) {}
        return parser.isExuberantCtags;
    }

    public void addResource(IProject project, IResource resource) {
        if (resource instanceof IProject) {
            this.indexAll(project);
        } else if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            this.indexSourceFolder(project, folder);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.addSource(file, project.getFullPath());
        } else {
            this.indexAll(project);
        }
    }

    public void removeResource(IProject project, IResource resource) {
        if (resource instanceof IProject) {
            IPath fullPath = project.getFullPath();
            this.indexManager.discardJobs(fullPath.segment(0));
            this.indexStorage.removeIndexFamily(fullPath);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.remove(file.getFullPath().toString(), file.getProject().getFullPath());
        }
    }

    public void addResourceByPath(IProject project, IPath path, int resourceType) {
    }

    public void setIndexerProject(IProject project) {
        this.setProject(project);
    }

    class CTagLineReader
    implements IConsoleParser {
        boolean isExuberantCtags = false;

        CTagLineReader() {
        }

        public boolean processLine(String line) {
            if (line.startsWith("Exuberant Ctags")) {
                this.isExuberantCtags = true;
            }
            return true;
        }

        public void shutdown() {
        }
    }
}

