/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner2;

import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ast.IASTFactory;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.internal.core.parser.ast.EmptyIterator;
import org.eclipse.cdt.internal.core.parser.scanner2.BaseScanner;
import org.eclipse.cdt.internal.core.parser.scanner2.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner2.IScannerExtensionConfiguration;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerCallbackManager;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerProblemFactory;
import org.eclipse.cdt.internal.core.parser.scanner2.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.token.ImagedExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.ImagedToken;
import org.eclipse.cdt.internal.core.parser.token.SimpleExpansionToken;
import org.eclipse.cdt.internal.core.parser.token.SimpleToken;

public class Scanner2
extends BaseScanner {
    protected IASTFactory astFactory;
    protected ScannerCallbackManager callbackManager;
    protected ISourceElementRequestor requestor;
    protected List workingCopies;
    protected static final ScannerProblemFactory spf = new ScannerProblemFactory();
    protected final CharArrayObjectMap fileCache = new CharArrayObjectMap(100);

    public Scanner2(CodeReader reader, IScannerInfo info, ISourceElementRequestor requestor, ParserMode parserMode, ParserLanguage language, IParserLogService log, List workingCopies, IScannerExtensionConfiguration configuration) {
        super(reader, info, parserMode, language, log, configuration);
        this.requestor = requestor;
        this.callbackManager = new ScannerCallbackManager(requestor);
        this.expressionEvaluator = new BaseScanner.ExpressionEvaluator(this.callbackManager, spf);
        this.workingCopies = workingCopies;
        this.postConstructorSetup(reader, info);
        if (reader.filename != null) {
            this.fileCache.put(reader.filename, reader);
        }
    }

    protected IASTFactory getASTFactory() {
        if (this.astFactory == null) {
            this.astFactory = ParserFactory.createASTFactory(this.parserMode, this.language);
        }
        return this.astFactory;
    }

    public final void setASTFactory(IASTFactory f) {
        this.astFactory = f;
    }

    protected Object createInclusionConstruct(char[] fileName, char[] filenamePath, boolean local, int startOffset, int startingLineNumber, int nameOffset, int nameEndOffset, int nameLine, int endOffset, int endLine, boolean isForced) {
        return this.getASTFactory().createInclusion(fileName, filenamePath, local, startOffset, startingLineNumber, nameOffset, nameEndOffset, nameLine, endOffset, endLine, this.getCurrentFilename(), isForced);
    }

    protected void processMacro(char[] name, int startingOffset, int startingLineNumber, int idstart, int idend, int nameLine, int textEnd, int endingLine, IMacro macro) {
        this.callbackManager.pushCallback(this.getASTFactory().createMacro(name, startingOffset, startingLineNumber, idstart, idend, nameLine, textEnd, endingLine, this.getCurrentFilename(), !this.isInitialized));
    }

    protected void pushContext(char[] buffer, Object data) {
        super.pushContext(buffer, data);
        if (data instanceof BaseScanner.InclusionData) {
            this.callbackManager.pushCallback(data);
            if (this.log.isTracing()) {
                StringBuffer b = new StringBuffer("Entering inclusion ");
                b.append(((BaseScanner.InclusionData)data).reader.filename);
                this.log.traceLog(b.toString());
            }
        }
    }

    protected void beforeSecondFetchToken() {
        if (this.callbackManager.hasCallbacks()) {
            this.callbackManager.popCallbacks();
        }
    }

    protected void quickParsePushPopInclusion(Object inclusion) {
        this.callbackManager.pushCallback(new BaseScanner.InclusionData(null, inclusion));
        this.callbackManager.pushCallback(inclusion);
    }

    protected CodeReader createReaderDuple(String finalPath) {
        return ScannerUtility.createReaderDuple(finalPath, this.requestor, this.getWorkingCopies());
    }

    public ILocationResolver getLocationResolver() {
        return null;
    }

    protected Iterator getWorkingCopies() {
        if (this.workingCopies == null) {
            return EmptyIterator.EMPTY_ITERATOR;
        }
        return this.workingCopies.iterator();
    }

    protected IToken newToken(int signal) {
        if (this.bufferData[this.bufferStackPos] instanceof BaseScanner.MacroData) {
            int mostRelevant = this.bufferStackPos;
            while (mostRelevant >= 0) {
                if (this.bufferData[mostRelevant] instanceof BaseScanner.InclusionData || this.bufferData[mostRelevant] instanceof CodeReader) break;
                --mostRelevant;
            }
            BaseScanner.MacroData data = (BaseScanner.MacroData)this.bufferData[mostRelevant + 1];
            return new SimpleExpansionToken(signal, data.startOffset, data.endOffset - data.startOffset + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[mostRelevant] + 1));
        }
        return new SimpleToken(signal, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
    }

    protected IToken newToken(int signal, char[] buffer) {
        if (this.bufferData[this.bufferStackPos] instanceof BaseScanner.MacroData) {
            int mostRelevant = this.bufferStackPos;
            while (mostRelevant >= 0) {
                if (this.bufferData[mostRelevant] instanceof BaseScanner.InclusionData || this.bufferData[mostRelevant] instanceof CodeReader) break;
                --mostRelevant;
            }
            BaseScanner.MacroData data = (BaseScanner.MacroData)this.bufferData[mostRelevant + 1];
            return new ImagedExpansionToken(signal, buffer, data.startOffset, data.endOffset - data.startOffset + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[mostRelevant] + 1));
        }
        ImagedToken i = new ImagedToken(signal, buffer, this.bufferPos[this.bufferStackPos] + 1, this.getCurrentFilename(), this.getLineNumber(this.bufferPos[this.bufferStackPos] + 1));
        if (buffer != null && buffer.length == 0 && signal != 130 && signal != 131) {
            int n = this.bufferStackPos;
            this.bufferPos[n] = this.bufferPos[n] + 1;
        }
        return i;
    }

    protected void handleProblem(int id, int offset, char[] arg) {
        if (this.parserMode == ParserMode.COMPLETION_PARSE) {
            return;
        }
        IProblem p = spf.createProblem(id, offset, this.bufferPos[this.bufferStackPos], this.getLineNumber(this.bufferPos[this.bufferStackPos]), this.getCurrentFilename(), arg != null ? arg : BaseScanner.EMPTY_CHAR_ARRAY, false, true);
        this.callbackManager.pushCallback(p);
    }

    protected Object popContext() {
        if (this.bufferData[this.bufferStackPos] instanceof BaseScanner.InclusionData) {
            if (this.log.isTracing()) {
                StringBuffer buffer = new StringBuffer("Exiting inclusion ");
                buffer.append(((BaseScanner.InclusionData)this.bufferData[this.bufferStackPos]).reader.filename);
                this.log.traceLog(buffer.toString());
            }
            this.callbackManager.pushCallback(((BaseScanner.InclusionData)this.bufferData[this.bufferStackPos]).inclusion);
        }
        return super.popContext();
    }

    protected void processIfdef(int startPos, int endPos, boolean positive, boolean taken) {
    }

    protected void processIf(int startPos, int endPos, boolean taken) {
    }

    protected void processElsif(int startPos, int endPos, boolean taken) {
    }

    protected void processElse(int startPos, int endPos, boolean taken) {
    }

    protected void processUndef(int pos, int endPos, char[] symbol, int namePos, Object definition) {
    }

    protected void processError(int startPos, int endPos) {
    }

    protected void processEndif(int pos, int i) {
    }

    protected void processPragma(int startPos, int endPos) {
    }

    protected CodeReader createReader(String path, String fileName) {
        String finalPath = ScannerUtility.createReconciledPath(path, fileName);
        char[] finalPathc = finalPath.toCharArray();
        CodeReader reader = (CodeReader)this.fileCache.get(finalPathc);
        if (reader != null) {
            return reader;
        }
        reader = this.createReaderDuple(finalPath);
        if (reader == null) {
            return null;
        }
        if (reader.filename != null) {
            this.fileCache.put(finalPathc, reader);
        }
        return reader;
    }
}

