/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.cdt.core.browser.PathUtil;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ast.ASTClassKind;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTQualifiedNameElement;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.search.BasicSearchMatch;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexInput;
import org.eclipse.cdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.cdt.internal.core.search.matching.CSearchPattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ClassDeclarationPattern
extends CSearchPattern {
    protected char[] simpleName;
    protected char[][] qualifications;
    protected ASTClassKind classKind;
    protected ICSearchConstants.SearchFor searchFor;
    protected char[] decodedSimpleName;
    private char[][] decodedContainingTypes;
    protected int decodedType;

    public ClassDeclarationPattern(char[] name, char[][] containers, ICSearchConstants.SearchFor searchFor, ICSearchConstants.LimitTo limit, int mode, boolean caseSensitive) {
        super(mode, caseSensitive, limit);
        char[] cArray = this.simpleName = caseSensitive ? name : CharOperation.toLowerCase(name);
        if (caseSensitive || containers == null) {
            this.qualifications = containers;
        } else {
            int len = containers.length;
            this.qualifications = new char[len][];
            int i = 0;
            while (i < len) {
                this.qualifications[i] = CharOperation.toLowerCase(containers[i]);
                ++i;
            }
        }
        this.searchFor = searchFor;
        this.classKind = searchFor == ICSearchConstants.CLASS ? ASTClassKind.CLASS : (searchFor == ICSearchConstants.STRUCT ? ASTClassKind.STRUCT : (searchFor == ICSearchConstants.ENUM ? ASTClassKind.ENUM : (searchFor == ICSearchConstants.UNION ? ASTClassKind.UNION : null)));
    }

    public int matchLevel(ISourceElementCallbackDelegate node, ICSearchConstants.LimitTo limit) {
        char[][] qualName;
        if (!(node instanceof IASTClassSpecifier || node instanceof IASTElaboratedTypeSpecifier || node instanceof IASTTypedefDeclaration || node instanceof IASTEnumerationSpecifier)) {
            return 0;
        }
        if (this.searchFor != ICSearchConstants.TYPE && this.searchFor == ICSearchConstants.TYPEDEF ^ node instanceof IASTTypedefDeclaration) {
            return 0;
        }
        if (!this.canAccept(limit)) {
            return 0;
        }
        char[] nodeName = null;
        if (node instanceof IASTElaboratedTypeSpecifier) {
            nodeName = ((IASTElaboratedTypeSpecifier)node).getNameCharArray();
        } else if (node instanceof IASTOffsetableNamedElement) {
            nodeName = ((IASTOffsetableNamedElement)node).getNameCharArray();
        } else {
            return 0;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, nodeName)) {
            return 0;
        }
        if (node instanceof IASTQualifiedNameElement && !this.matchQualifications(this.qualifications, qualName = ((IASTQualifiedNameElement)node).getFullyQualifiedNameCharArrays(), true)) {
            return 0;
        }
        if (this.classKind != null) {
            if (node instanceof IASTClassSpecifier) {
                IASTClassSpecifier clsSpec = (IASTClassSpecifier)node;
                return this.classKind == clsSpec.getClassKind() ? 2 : 0;
            }
            if (node instanceof IASTEnumerationSpecifier) {
                return this.classKind == ASTClassKind.ENUM ? 2 : 0;
            }
            if (node instanceof IASTElaboratedTypeSpecifier) {
                IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)node;
                return this.classKind == elabTypeSpec.getClassKind() ? 2 : 0;
            }
        }
        return 2;
    }

    public char[] getName() {
        return this.simpleName;
    }

    public char[][] getContainingTypes() {
        return this.qualifications;
    }

    public ASTClassKind getKind() {
        return this.classKind;
    }

    public void feedIndexRequestor(IIndexSearchRequestor requestor, int detailLevel, int[] fileRefs, int[][] offsets, int[][] offsetLengths, IndexInput input, ICSearchScope scope) throws IOException {
        boolean bl = this.decodedType == 1;
        int i = 0;
        int max = fileRefs.length;
        while (i < max) {
            String path;
            IndexedFileEntry file = input.getIndexedFile(fileRefs[i]);
            if (file != null && scope.encloses(path = file.getPath())) {
                int j = 0;
                while (j < offsets[i].length) {
                    BasicSearchMatch match = new BasicSearchMatch();
                    match.setName(new String(this.decodedSimpleName));
                    if (this.decodedContainingTypes != null) {
                        String[] qualifiedName = new String[this.decodedContainingTypes.length];
                        int k = 0;
                        while (k < this.decodedContainingTypes.length) {
                            qualifiedName[k] = new String(this.decodedContainingTypes[k]);
                            ++k;
                        }
                        match.setQualifiedName(qualifiedName);
                    }
                    match.setLocatable(CSearchPattern.getMatchLocatable(offsets[i][j], offsetLengths[i][j]));
                    match.setParentName("");
                    switch (this.decodedType) {
                        case 1: {
                            match.setType(65);
                            break;
                        }
                        case 2: {
                            match.setType(67);
                            break;
                        }
                        case 3: {
                            match.setType(69);
                            break;
                        }
                        case 4: {
                            match.setType(63);
                            break;
                        }
                        case 5: {
                            match.setType(80);
                        }
                    }
                    IFile tempFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
                    if (tempFile != null && tempFile.exists()) {
                        match.setResource((IResource)tempFile);
                    } else {
                        IPath tempPath = PathUtil.getWorkspaceRelativePath(file.getPath());
                        match.setPath(tempPath);
                        match.setReferringElement(tempPath);
                    }
                    requestor.acceptSearchMatch(match);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void resetIndexInfo() {
        this.decodedType = 0;
        this.decodedSimpleName = null;
        this.decodedContainingTypes = null;
    }

    protected void decodeIndexEntry(IEntryResult entryResult) {
        this.decodedType = entryResult.getKind();
        this.decodedSimpleName = entryResult.extractSimpleName().toCharArray();
        String[] missmatch = entryResult.getEnclosingNames();
        if (missmatch != null) {
            this.decodedContainingTypes = new char[missmatch.length][];
            int i = 0;
            while (i < missmatch.length) {
                this.decodedContainingTypes[i] = missmatch[i].toCharArray();
                ++i;
            }
        }
    }

    public char[] indexEntryPrefix() {
        return Index.bestTypePrefix(this.searchFor, this.getLimitTo(), this.simpleName, this.qualifications, this._matchMode, this._caseSensitive);
    }

    protected boolean matchIndexEntry() {
        if (this.classKind == null ? this.searchFor == ICSearchConstants.TYPEDEF && this.decodedType != 5 : (this.classKind == ASTClassKind.CLASS ? this.decodedType != 1 : (this.classKind == ASTClassKind.STRUCT ? this.decodedType != 2 : (this.classKind == ASTClassKind.UNION ? this.decodedType != 3 : this.classKind == ASTClassKind.ENUM && this.decodedType != 4)))) {
            return false;
        }
        if (this.simpleName != null && !this.matchesName(this.simpleName, this.decodedSimpleName)) {
            return false;
        }
        return this.matchQualifications(this.qualifications, this.decodedContainingTypes);
    }
}

