/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.internal.refactoring.ASTManager;
import org.eclipse.cdt.internal.refactoring.CRefactoringArgument;
import org.eclipse.cdt.internal.refactoring.CRefactoringUtils;
import org.eclipse.cdt.internal.refactoring.CRenameGlobalProcessor;
import org.eclipse.cdt.internal.refactoring.CRenameProcessor;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;

public class CRenameMethodProcessor
extends CRenameGlobalProcessor {
    public CRenameMethodProcessor(CRenameProcessor processor, String kind) {
        super(processor, kind);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws OperationCanceledException, CoreException {
        CRefactoringArgument argument = this.getArgument();
        IBinding binding = argument.getBinding();
        if (binding instanceof ICPPConstructor) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameMethodProcessor.fatalError.renameConstructor"));
        }
        String identifier = argument.getName();
        if (identifier.startsWith("~")) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameMethodProcessor.fatalError.renameDestructor"));
        }
        if (identifier.startsWith("operator") && identifier.length() > 8 && !CRefactoringUtils.isIdentifierChar(identifier.charAt(8))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameMethodProcessor.fatalError.renameOperator"));
        }
        return super.checkInitialConditions(pm);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException, CoreException {
        CRefactoringArgument argument = this.getArgument();
        RefactoringStatus result = new RefactoringStatus();
        IScope scope = argument.getScope();
        if (scope != null) {
            IASTNode node = null;
            try {
                node = scope.getPhysicalNode();
            }
            catch (DOMException e) {
                this.getAstManager().handleDOMException(argument.getTranslationUnit(), e, result);
            }
            if (node instanceof IASTCompositeTypeSpecifier) {
                IASTCompositeTypeSpecifier se = (IASTCompositeTypeSpecifier)node;
                IASTName name = ASTManager.getSimpleName(se.getName());
                if (this.getReplacementText().equals(name.toString())) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameMethodProcessor.fatalError.renameToConstructor"));
                }
                if (this.getReplacementText().startsWith("~")) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.getString("CRenameMethodProcessor.fatalError.renameToDestructor"));
                }
                if (!CRefactoringUtils.checkIdentifier(this.getReplacementText())) {
                    result.merge(RefactoringStatus.createErrorStatus((String)Messages.getString("CRenameMethodProcessor.warning.illegalCharacters")));
                }
            }
        }
        if (argument.getArgumentKind() == 8) {
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.getString("CRenameMethodProcessor.warning.renameVirtual")));
        }
        result.merge(super.checkFinalConditions(monitor, context));
        return result;
    }
}

