/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.search.matching;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.CodeReader;
import org.eclipse.cdt.core.parser.IParser;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IProblem;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfoProvider;
import org.eclipse.cdt.core.parser.ISourceElementCallbackDelegate;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ParserFactory;
import org.eclipse.cdt.core.parser.ParserFactoryError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.ParserMode;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.core.parser.ast.IASTASMDefinition;
import org.eclipse.cdt.core.parser.ast.IASTAbstractTypeSpecifierDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTClassReference;
import org.eclipse.cdt.core.parser.ast.IASTClassSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTCodeScope;
import org.eclipse.cdt.core.parser.ast.IASTCompilationUnit;
import org.eclipse.cdt.core.parser.ast.IASTDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationReference;
import org.eclipse.cdt.core.parser.ast.IASTEnumerationSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTEnumerator;
import org.eclipse.cdt.core.parser.ast.IASTEnumeratorReference;
import org.eclipse.cdt.core.parser.ast.IASTField;
import org.eclipse.cdt.core.parser.ast.IASTFieldReference;
import org.eclipse.cdt.core.parser.ast.IASTFunction;
import org.eclipse.cdt.core.parser.ast.IASTFunctionReference;
import org.eclipse.cdt.core.parser.ast.IASTInclusion;
import org.eclipse.cdt.core.parser.ast.IASTLinkageSpecification;
import org.eclipse.cdt.core.parser.ast.IASTMacro;
import org.eclipse.cdt.core.parser.ast.IASTMethod;
import org.eclipse.cdt.core.parser.ast.IASTMethodReference;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceDefinition;
import org.eclipse.cdt.core.parser.ast.IASTNamespaceReference;
import org.eclipse.cdt.core.parser.ast.IASTOffsetableNamedElement;
import org.eclipse.cdt.core.parser.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTReference;
import org.eclipse.cdt.core.parser.ast.IASTScope;
import org.eclipse.cdt.core.parser.ast.IASTTemplateDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTemplateInstantiation;
import org.eclipse.cdt.core.parser.ast.IASTTemplateParameterReference;
import org.eclipse.cdt.core.parser.ast.IASTTemplateSpecialization;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTTypedefReference;
import org.eclipse.cdt.core.parser.ast.IASTUsingDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTUsingDirective;
import org.eclipse.cdt.core.parser.ast.IASTVariable;
import org.eclipse.cdt.core.parser.ast.IASTVariableReference;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchPattern;
import org.eclipse.cdt.core.search.ICSearchResultCollector;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.core.search.IMatchLocator;
import org.eclipse.cdt.internal.core.search.AcceptMatchOperation;
import org.eclipse.cdt.internal.core.search.indexing.IndexProblemHandler;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class MatchLocator
implements IMatchLocator,
ISourceElementRequestor {
    ArrayList matchStorage;
    public static boolean VERBOSE = false;
    private boolean shouldExcludeLocalDeclarations = false;
    private ISourceElementCallbackDelegate lastDeclaration;
    private ICSearchPattern searchPattern;
    private ICSearchResultCollector resultCollector;
    private IProgressMonitor progressMonitor;
    private IPath currentPath = null;
    private ICSearchScope searchScope;
    private IWorkspaceRoot workspaceRoot;
    private IPath realPath;
    private IResource currentResource = null;
    private LinkedList resourceStack = new LinkedList();
    private IASTScope currentScope = null;
    private LinkedList scopeStack = new LinkedList();

    public MatchLocator(ICSearchPattern pattern, ICSearchResultCollector collector, ICSearchScope scope) {
        this.searchPattern = pattern;
        this.resultCollector = collector;
        this.searchScope = scope;
    }

    public boolean acceptProblem(IProblem problem) {
        return IndexProblemHandler.ruleOnProblem(problem, ParserMode.COMPLETE_PARSE);
    }

    public void acceptUsingDirective(IASTUsingDirective usageDirective) {
    }

    public void acceptUsingDeclaration(IASTUsingDeclaration usageDeclaration) {
    }

    public void acceptASMDefinition(IASTASMDefinition asmDefinition) {
    }

    public void acceptAbstractTypeSpecDeclaration(IASTAbstractTypeSpecifierDeclaration abstractDeclaration) {
    }

    public void enterTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void enterTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void enterTemplateInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void exitTemplateDeclaration(IASTTemplateDeclaration declaration) {
    }

    public void exitTemplateSpecialization(IASTTemplateSpecialization specialization) {
    }

    public void exitTemplateExplicitInstantiation(IASTTemplateInstantiation instantiation) {
    }

    public void enterCodeBlock(IASTCodeScope scope) {
    }

    public void exitCodeBlock(IASTCodeScope scope) {
    }

    public void enterLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.pushScope((IASTScope)linkageSpec);
    }

    public void exitLinkageSpecification(IASTLinkageSpecification linkageSpec) {
        this.popScope();
    }

    public void acceptParameterReference(IASTParameterReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptTemplateParameterReference(IASTTemplateParameterReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptTypedefDeclaration(IASTTypedefDeclaration typedef) {
        this.lastDeclaration = typedef;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)typedef);
    }

    public void acceptTypedefReference(IASTTypedefReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptEnumeratorReference(IASTEnumeratorReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptMacro(IASTMacro macro) {
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)macro);
    }

    public void acceptVariable(IASTVariable variable) {
        this.lastDeclaration = variable;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)variable);
        if (variable.getInitializerClause() != null || !variable.isExtern() && !(this.currentScope instanceof IASTLinkageSpecification)) {
            this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)variable);
        }
    }

    public void acceptField(IASTField field) {
        this.lastDeclaration = field;
        if (this.currentScope instanceof IASTClassSpecifier) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)field);
            if (!field.isStatic()) {
                this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)field);
            }
        } else {
            this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)field);
        }
    }

    public void acceptEnumerationSpecifier(IASTEnumerationSpecifier enumeration) {
        this.lastDeclaration = enumeration;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)enumeration);
        Iterator iter = enumeration.getEnumerators();
        while (iter.hasNext()) {
            IASTEnumerator enumerator = (IASTEnumerator)iter.next();
            this.lastDeclaration = enumerator;
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)enumerator);
        }
    }

    public void acceptFunctionDeclaration(IASTFunction function) {
        this.lastDeclaration = function;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)function);
    }

    public void acceptMethodDeclaration(IASTMethod method) {
        this.lastDeclaration = method;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)method);
    }

    public void acceptClassReference(IASTClassReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptNamespaceReference(IASTNamespaceReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptVariableReference(IASTVariableReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptFieldReference(IASTFieldReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptEnumerationReference(IASTEnumerationReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptFunctionReference(IASTFunctionReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void acceptMethodReference(IASTMethodReference reference) {
        this.check(ICSearchConstants.REFERENCES, (ISourceElementCallbackDelegate)reference);
    }

    public void enterFunctionBody(IASTFunction function) {
        this.lastDeclaration = function;
        if (!function.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)function);
        }
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)function);
        Iterator parms = function.getParameters();
        while (parms.hasNext()) {
            Object tempParm = parms.next();
            if (!(tempParm instanceof IASTParameterDeclaration)) continue;
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)((IASTParameterDeclaration)tempParm));
        }
        this.pushScope((IASTScope)function);
    }

    public void enterMethodBody(IASTMethod method) {
        this.lastDeclaration = method;
        if (!method.previouslyDeclared()) {
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)method);
        }
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)method);
        Iterator parms = method.getParameters();
        while (parms.hasNext()) {
            Object tempParm = parms.next();
            if (!(tempParm instanceof IASTParameterDeclaration)) continue;
            this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)((IASTParameterDeclaration)tempParm));
        }
        this.pushScope((IASTScope)method);
    }

    public void enterCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.pushScope((IASTScope)compilationUnit);
    }

    public void enterNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.lastDeclaration = namespaceDefinition;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)namespaceDefinition);
        this.check(ICSearchConstants.DEFINITIONS, (ISourceElementCallbackDelegate)namespaceDefinition);
        this.pushScope((IASTScope)namespaceDefinition);
    }

    public void enterClassSpecifier(IASTClassSpecifier classSpecification) {
        this.lastDeclaration = classSpecification;
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)classSpecification);
        this.pushScope((IASTScope)classSpecification);
    }

    public void exitFunctionBody(IASTFunction function) {
        this.popScope();
    }

    public void exitMethodBody(IASTMethod method) {
        this.popScope();
    }

    public void exitClassSpecifier(IASTClassSpecifier classSpecification) {
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)classSpecification);
        this.popScope();
    }

    public void exitNamespaceDefinition(IASTNamespaceDefinition namespaceDefinition) {
        this.popScope();
    }

    public void exitCompilationUnit(IASTCompilationUnit compilationUnit) {
        this.popScope();
    }

    public void enterInclusion(IASTInclusion inclusion) {
        String includePath = inclusion.getFullFileName();
        Path path = new Path(includePath);
        IFile resource = null;
        if (this.workspaceRoot != null) {
            resource = this.workspaceRoot.getFileForLocation((IPath)path);
        }
        this.resourceStack.addFirst(this.currentResource != null ? this.currentResource : this.currentPath);
        this.currentResource = resource;
        this.currentPath = resource == null ? path : null;
    }

    public void exitInclusion(IASTInclusion inclusion) {
        Object obj = this.resourceStack.removeFirst();
        if (obj instanceof IResource) {
            this.currentResource = (IResource)obj;
            this.currentPath = null;
        } else {
            this.currentPath = (IPath)obj;
            this.currentResource = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void locateMatches(String[] paths, IWorkspace workspace, IWorkingCopy[] workingCopies) throws InterruptedException {
        int i;
        int wcLength;
        this.matchStorage = new ArrayList();
        this.workspaceRoot = workspace != null ? workspace.getRoot() : null;
        HashMap<String, IWorkingCopy> wcPaths = new HashMap<String, IWorkingCopy>();
        int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
        if (wcLength > 0) {
            String[] newPaths = new String[wcLength];
            i = 0;
            while (i < wcLength) {
                IWorkingCopy workingCopy = workingCopies[i];
                String path = workingCopy.getOriginalElement().getPath().toString();
                wcPaths.put(path, workingCopy);
                newPaths[i] = path;
                ++i;
            }
            int len = paths.length;
            String[] tempArray = new String[len + wcLength];
            System.arraycopy(paths, 0, tempArray, 0, len);
            System.arraycopy(newPaths, 0, tempArray, len, wcLength);
            paths = tempArray;
        }
        Arrays.sort(paths);
        int length = paths.length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("", length);
        }
        i = 0;
        while (i < length) {
            block39: {
                AcceptMatchOperation acceptMatchOp;
                Object var16_20;
                IScannerInfo buildScanInfo;
                IResource project;
                CodeReader reader;
                String pathString;
                block40: {
                    Object var14_15;
                    block42: {
                        if (this.progressMonitor != null) {
                            if (this.progressMonitor.isCanceled()) {
                                throw new InterruptedException();
                            }
                            this.progressMonitor.worked(1);
                        }
                        pathString = paths[i];
                        if (i > 0 && pathString.equals(paths[i - 1]) || !this.searchScope.encloses(pathString)) break block39;
                        reader = null;
                        this.realPath = null;
                        project = null;
                        if (this.workspaceRoot == null) break block40;
                        IWorkingCopy workingCopy = (IWorkingCopy)wcPaths.get(pathString);
                        if (workingCopy == null) break block42;
                        this.currentResource = workingCopy.getResource();
                        if (this.currentResource == null || !this.currentResource.isAccessible()) break block39;
                        reader = new CodeReader(this.currentResource.getLocation().toOSString(), workingCopy.getContents());
                        this.realPath = this.currentResource.getLocation();
                        project = this.currentResource.getProject();
                        break block40;
                    }
                    this.currentResource = this.workspaceRoot.findMember(pathString, true);
                    InputStream contents = null;
                    try {
                        block38: {
                            try {
                                if (this.currentResource == null) break block38;
                                if (this.currentResource.isAccessible() && this.currentResource instanceof IFile) {
                                    IFile file = (IFile)this.currentResource;
                                    contents = file.getContents();
                                    reader = new CodeReader(this.currentResource.getLocation().toOSString(), file.getCharset(), contents);
                                    this.realPath = this.currentResource.getLocation();
                                    project = file.getProject();
                                    break block38;
                                }
                                var14_15 = null;
                                if (contents != null) {
                                    try {
                                        contents.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block39;
                            }
                            catch (CoreException coreException) {
                                var14_15 = null;
                                if (contents != null) {
                                    try {}
                                    catch (IOException iOException) {}
                                    contents.close();
                                }
                                break block39;
                            }
                            catch (IOException iOException) {
                                var14_15 = null;
                                if (contents != null) {
                                    try {}
                                    catch (IOException iOException2) {}
                                    contents.close();
                                }
                                break block39;
                            }
                        }
                        var14_15 = null;
                        if (contents == null) break block40;
                    }
                    catch (Throwable throwable) {
                        var14_15 = null;
                        if (contents == null) throw throwable;
                        try {}
                        catch (IOException iOException) {}
                        contents.close();
                        throw throwable;
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    contents.close();
                }
                if (this.currentResource == null) {
                    try {
                        Path path = new Path(pathString);
                        this.currentPath = path;
                        reader = new CodeReader(pathString);
                        this.realPath = this.currentPath;
                    }
                    catch (IOException iOException) {
                        break block39;
                    }
                }
                ScannerInfo scanInfo = new ScannerInfo();
                IScannerInfoProvider provider = CCorePlugin.getDefault().getScannerInfoProvider((IProject)project);
                if (provider != null && (buildScanInfo = provider.getScannerInformation(this.currentResource != null ? this.currentResource : project)) != null) {
                    scanInfo = new ScannerInfo(buildScanInfo.getDefinedSymbols(), buildScanInfo.getIncludePaths());
                }
                ParserLanguage language = null;
                language = project != null ? (CoreModel.hasCCNature((IProject)project) ? ParserLanguage.CPP : ParserLanguage.C) : ParserLanguage.CPP;
                IParser parser = null;
                try {
                    IScanner scanner = ParserFactory.createScanner((CodeReader)reader, (IScannerInfo)scanInfo, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (ISourceElementRequestor)this, (IParserLogService)ParserUtil.getScannerLogService(), null);
                    parser = ParserFactory.createParser((IScanner)scanner, (ISourceElementRequestor)this, (ParserMode)ParserMode.COMPLETE_PARSE, (ParserLanguage)language, (IParserLogService)ParserUtil.getParserLogService());
                }
                catch (ParserFactoryError parserFactoryError) {}
                if (VERBOSE) {
                    MatchLocator.verbose("*** New Search for path: " + pathString);
                }
                try {
                    block41: {
                        try {
                            parser.parse();
                        }
                        catch (Exception ex) {
                            if (VERBOSE) {
                                ex.printStackTrace();
                            }
                        }
                        catch (VirtualMachineError vmErr) {
                            if (!VERBOSE) break block41;
                            MatchLocator.verbose("MatchLocator VM Error: ");
                            vmErr.printStackTrace();
                        }
                    }
                    var16_20 = null;
                    this.scopeStack.clear();
                    this.resourceStack.clear();
                    this.lastDeclaration = null;
                    this.currentScope = null;
                    parser = null;
                    if (this.matchStorage.size() <= 0) break block39;
                    acceptMatchOp = new AcceptMatchOperation(this.resultCollector, this.matchStorage);
                }
                catch (Throwable throwable) {
                    var16_20 = null;
                    this.scopeStack.clear();
                    this.resourceStack.clear();
                    this.lastDeclaration = null;
                    this.currentScope = null;
                    parser = null;
                    throw throwable;
                }
                try {
                    CCorePlugin.getWorkspace().run((IWorkspaceRunnable)acceptMatchOp, null);
                }
                catch (CoreException coreException) {}
                this.matchStorage.clear();
            }
            ++i;
        }
    }

    protected void report(ISourceElementCallbackDelegate node, int accuracyLevel) {
        try {
            if (this.currentResource != null && !this.searchScope.encloses(this.currentResource.getFullPath().toOSString())) {
                return;
            }
            int offset = 0;
            int end = 0;
            if (node instanceof IASTReference) {
                IASTReference reference = (IASTReference)node;
                offset = reference.getOffset();
                end = offset + reference.getName().length();
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + reference.getName());
                }
            } else if (node instanceof IASTOffsetableNamedElement) {
                IASTOffsetableNamedElement offsetableElement = (IASTOffsetableNamedElement)node;
                offset = offsetableElement.getNameOffset() != 0 ? offsetableElement.getNameOffset() : offsetableElement.getStartingOffset();
                end = offsetableElement.getNameEndOffset();
                if (end == 0) {
                    end = offset + offsetableElement.getName().length();
                }
                if (VERBOSE) {
                    MatchLocator.verbose("Report Match: " + offsetableElement.getName());
                }
            }
            IMatch match = null;
            ISourceElementCallbackDelegate object = null;
            if (node instanceof IASTReference) {
                object = this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod ? (ISourceElementCallbackDelegate)this.currentScope : this.lastDeclaration;
            } else if (this.currentScope instanceof IASTFunction || this.currentScope instanceof IASTMethod) {
                if (this.shouldExcludeLocalDeclarations) {
                    return;
                }
                object = (ISourceElementCallbackDelegate)this.currentScope;
            } else {
                object = node;
            }
            if (this.currentResource != null) {
                match = this.resultCollector.createMatch(this.currentResource, offset, end, object, null);
            } else if (this.currentPath != null) {
                match = this.resultCollector.createMatch(this.currentPath, offset, end, object, this.realPath);
            }
            if (match != null) {
                this.matchStorage.add(match);
            }
        }
        catch (CoreException coreException) {}
    }

    private void check(ICSearchConstants.LimitTo limit, ISourceElementCallbackDelegate node) {
        if (!this.searchPattern.canAccept(limit)) {
            return;
        }
        int level = 0;
        level = node instanceof IASTReference ? this.searchPattern.matchLevel(((IASTReference)node).getReferencedElement(), limit) : this.searchPattern.matchLevel(node, limit);
        if (level != 0) {
            this.report(node, level);
        }
    }

    private void pushScope(IASTScope scope) {
        this.scopeStack.addFirst(this.currentScope);
        this.currentScope = scope;
    }

    private IASTScope popScope() {
        IASTScope oldScope = this.currentScope;
        this.currentScope = this.scopeStack.size() > 0 ? (IASTScope)this.scopeStack.removeFirst() : null;
        return oldScope;
    }

    public void setShouldExcludeLocalDeclarations(boolean exclude) {
        this.shouldExcludeLocalDeclarations = exclude;
    }

    public void acceptElaboratedForewardDeclaration(IASTElaboratedTypeSpecifier elaboratedType) {
        this.check(ICSearchConstants.DECLARATIONS, (ISourceElementCallbackDelegate)elaboratedType);
    }

    public void acceptFriendDeclaration(IASTDeclaration declaration) {
    }

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public CodeReader createReader(String finalPath, Iterator workingCopies) {
        return ParserUtil.createReader(finalPath, workingCopies);
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

