/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.c.ICASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTSimpleDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICASTTypedefNameSpecifier;
import org.eclipse.cdt.core.dom.ast.c.ICQualifierType;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.c.CBasicType;

public class CQualifierType
implements ICQualifierType,
ITypeContainer {
    private boolean isConst;
    private boolean isVolatile;
    private boolean isRestrict;
    private IType type = null;

    public CQualifierType(ICASTDeclSpecifier declSpec) {
        this.type = this.resolveType(declSpec);
        this.isConst = declSpec.isConst();
        this.isVolatile = declSpec.isVolatile();
        this.isRestrict = declSpec.isRestrict();
    }

    public CQualifierType(IType type, boolean isConst, boolean isVolatile, boolean isRestrict) {
        this.type = type;
        this.isConst = isConst;
        this.isVolatile = isVolatile;
        this.isRestrict = isRestrict;
    }

    public boolean isSameType(IType obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ITypedef) {
            return obj.isSameType(this);
        }
        if (obj instanceof ICQualifierType) {
            ICQualifierType qt = (ICQualifierType)obj;
            try {
                if (this.isConst() != qt.isConst()) {
                    return false;
                }
                if (this.isRestrict() != qt.isRestrict()) {
                    return false;
                }
                if (this.isVolatile() != qt.isVolatile()) {
                    return false;
                }
                if (this.type == null) {
                    return false;
                }
                return this.type.isSameType(qt.getType());
            }
            catch (DOMException dOMException) {
                return false;
            }
        }
        return false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    private IType resolveType(ICASTDeclSpecifier declSpec) {
        IType t = null;
        if (declSpec instanceof ICASTTypedefNameSpecifier) {
            ICASTTypedefNameSpecifier nameSpec = (ICASTTypedefNameSpecifier)declSpec;
            t = (IType)((Object)nameSpec.getName().resolveBinding());
        } else if (declSpec instanceof IASTElaboratedTypeSpecifier) {
            IASTElaboratedTypeSpecifier elabTypeSpec = (IASTElaboratedTypeSpecifier)((Object)declSpec);
            t = (IType)((Object)elabTypeSpec.getName().resolveBinding());
        } else if (declSpec instanceof IASTCompositeTypeSpecifier) {
            IASTCompositeTypeSpecifier compTypeSpec = (IASTCompositeTypeSpecifier)((Object)declSpec);
            t = (IType)((Object)compTypeSpec.getName().resolveBinding());
        } else {
            t = new CBasicType((ICASTSimpleDeclSpecifier)declSpec);
        }
        return t;
    }

    public IType getType() {
        return this.type;
    }

    public void setType(IType t) {
        this.type = t;
    }

    public Object clone() {
        IType t = null;
        try {
            t = (IType)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return t;
    }
}

