/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.properties;

import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class BuildOptionComboFieldEditor
extends FieldEditor {
    private Combo optionSelector;
    private String[] options = new String[0];
    private String selected;

    public BuildOptionComboFieldEditor(String name, String label, String[] opts, String sel, Composite parent) {
        this.init(name, label);
        this.options = opts;
        this.selected = sel;
        this.createControl(parent);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.optionSelector.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        parent.setLayoutData((Object)gd);
        Label label = this.getLabelControl(parent);
        GridData labelData = new GridData();
        labelData.horizontalSpan = 1;
        labelData.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)labelData);
        this.optionSelector = ControlFactory.createSelectCombo((Composite)parent, (String[])this.options, (String)this.selected);
        GridData selectorData = (GridData)this.optionSelector.getLayoutData();
        selectorData.horizontalSpan = numColumns - 1;
        selectorData.grabExcessHorizontalSpace = true;
        this.optionSelector.setLayoutData((Object)selectorData);
        this.optionSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                String oldValue = BuildOptionComboFieldEditor.this.selected;
                BuildOptionComboFieldEditor.this.optionSelector.getText();
                int index = BuildOptionComboFieldEditor.this.optionSelector.getSelectionIndex();
                BuildOptionComboFieldEditor.this.selected = index == -1 ? new String() : BuildOptionComboFieldEditor.this.optionSelector.getItem(index);
                BuildOptionComboFieldEditor.this.setPresentsDefaultValue(false);
                BuildOptionComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, BuildOptionComboFieldEditor.this.selected);
            }
        });
    }

    protected void doLoad() {
        this.optionSelector.removeAll();
        this.optionSelector.setItems(this.options);
        this.selected = this.getPreferenceStore().getString(this.getPreferenceName());
        int index = this.optionSelector.indexOf(this.selected);
        this.optionSelector.select(index >= 0 ? index : 0);
    }

    protected void doLoadDefault() {
        this.doLoad();
    }

    protected void doStore() {
        int index = this.optionSelector.getSelectionIndex();
        this.selected = index == -1 ? new String() : this.optionSelector.getItem(index);
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.selected);
    }

    public String getSelection() {
        return this.selected;
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getLabelControl(parent).setEnabled(enabled);
        this.optionSelector.setEnabled(enabled);
    }
}

