/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class CCompletionProposal
implements ICCompletionProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3 {
    private String fDisplayString;
    private String fIdString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;
    private Image fImage;
    private IContextInformation fContextInformation;
    private int fContextInformationPosition;
    private String fProposalInfo;
    private char[] fTriggerCharacters;
    protected boolean fToggleEating;
    protected ITextViewer fTextViewer;
    private int fRelevance;
    private StyleRange fRememberedStyleRange;

    public CCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, null, relevance, null);
    }

    public CCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, ITextViewer viewer) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, null, relevance, viewer);
    }

    public CCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, String idString, int relevance, ITextViewer viewer) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementString = replacementString;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fImage = image;
        this.fRelevance = relevance;
        this.fTextViewer = viewer;
        this.fDisplayString = displayString != null ? displayString : replacementString;
        this.fIdString = idString != null ? idString : displayString;
        this.fCursorPosition = replacementString.length();
        this.fContextInformation = null;
        this.fContextInformationPosition = -1;
        this.fTriggerCharacters = null;
        this.fProposalInfo = null;
    }

    public void setContextInformation(IContextInformation contextInformation) {
        this.fContextInformation = contextInformation;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void setTriggerCharacters(char[] triggerCharacters) {
        this.fTriggerCharacters = triggerCharacters;
    }

    public void setAdditionalProposalInfo(String proposalInfo) {
        this.fProposalInfo = proposalInfo;
    }

    public void setCursorPosition(int cursorPosition) {
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        this.fCursorPosition = cursorPosition;
        this.fContextInformationPosition = this.fContextInformation != null ? this.fCursorPosition : -1;
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            int index;
            String string;
            int delta = offset - (this.fReplacementOffset + this.fReplacementLength);
            if (delta > 0) {
                this.fReplacementLength += delta;
            }
            if (trigger == '\u0000') {
                string = this.fReplacementString;
            } else {
                StringBuffer buffer = new StringBuffer(this.fReplacementString);
                if (this.fCursorPosition > 0 && this.fCursorPosition <= buffer.length() && buffer.charAt(this.fCursorPosition - 1) != trigger) {
                    buffer.insert(this.fCursorPosition, trigger);
                    ++this.fCursorPosition;
                }
                string = buffer.toString();
            }
            int referenceOffset = this.fReplacementOffset + this.fReplacementLength;
            ReferenceTracker referenceTracker = new ReferenceTracker();
            referenceTracker.preReplace(document, referenceOffset);
            this.replace(document, this.fReplacementOffset, this.fReplacementLength, string);
            referenceOffset = referenceTracker.postReplace(document);
            this.fReplacementOffset = referenceOffset - (string == null ? 0 : string.length());
            if (this.fTextViewer != null && string != null && (index = string.indexOf("()")) != -1 && index + 1 == this.fCursorPosition) {
                CUIPlugin.getDefault().getPreferenceStore();
                int newOffset = this.fReplacementOffset + this.fCursorPosition;
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, newOffset, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addGroup(group);
                model.forceInstall();
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.fTextViewer);
                ui.setSimpleMode(true);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(')'));
                ui.setExitPosition(this.fTextViewer, newOffset + 1, 0, Integer.MAX_VALUE);
                ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                ui.enter();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    private void replace(IDocument document, int offset, int length, String string) throws BadLocationException {
        if (!document.get(offset, length).equals(string)) {
            document.replace(offset, length, string);
        }
    }

    public void apply(IDocument document) {
        this.apply(document, '\u0000', this.fReplacementOffset + this.fReplacementLength);
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public IContextInformation getContextInformation() {
        return this.fContextInformation;
    }

    public Image getImage() {
        return this.fImage;
    }

    public String getDisplayString() {
        return this.fDisplayString;
    }

    public String getIdString() {
        return this.fIdString;
    }

    public String getAdditionalProposalInfo() {
        if (this.fProposalInfo != null) {
            return this.fProposalInfo;
        }
        return null;
    }

    public char[] getTriggerCharacters() {
        return this.fTriggerCharacters;
    }

    public int getContextInformationPosition() {
        return this.fReplacementOffset + this.fContextInformationPosition;
    }

    public int getReplacementOffset() {
        return this.fReplacementOffset;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.getReplacementOffset();
    }

    public void setReplacementOffset(int replacementOffset) {
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        this.fReplacementOffset = replacementOffset;
    }

    public int getReplacementLength() {
        return this.fReplacementLength;
    }

    public void setReplacementLength(int replacementLength) {
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.fReplacementLength = replacementLength;
    }

    public String getReplacementString() {
        return this.fReplacementString;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        return string;
    }

    public void setReplacementString(String replacementString) {
        this.fReplacementString = replacementString;
    }

    public void setImage(Image image) {
        this.fImage = image;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (offset < this.fReplacementOffset) {
            return false;
        }
        boolean validated = this.startsWith(document, offset, this.fDisplayString);
        if (validated && event != null) {
            int delta = (event.fText == null ? 0 : event.fText.length()) - event.fLength;
            this.fReplacementLength += delta;
        }
        return validated;
    }

    public int getRelevance() {
        return this.fRelevance;
    }

    public void setRelevance(int relevance) {
        this.fRelevance = relevance;
    }

    protected boolean startsWith(IDocument document, int offset, String word) {
        int wordLength;
        int n = wordLength = word == null ? 0 : word.length();
        if (offset > this.fReplacementOffset + wordLength) {
            return false;
        }
        try {
            int length = offset - this.fReplacementOffset;
            String start = document.get(this.fReplacementOffset, length);
            return word.substring(0, length).equalsIgnoreCase(start);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private static boolean insertCompletion() {
        IPreferenceStore preference = CUIPlugin.getDefault().getPreferenceStore();
        return preference.getBoolean("content_assist_autoinsert");
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        boolean bl = this.fToggleEating = (stateMask & SWT.MOD1) != 0;
        if (CCompletionProposal.insertCompletion() ^ this.fToggleEating) {
            this.fReplacementLength = selection.x + selection.y - this.fReplacementOffset;
        }
        this.apply(document, trigger, offset);
        this.fToggleEating = false;
    }

    private static Color getForegroundColor(StyledText text) {
        IPreferenceStore preference = CUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_proposals_foreground");
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private static Color getBackgroundColor(StyledText text) {
        IPreferenceStore preference = CUIPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preference, (String)"content_assist_proposals_background");
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        return textTools.getColorManager().getColor(rgb);
    }

    private void repairPresentation(ITextViewer viewer) {
        if (this.fRememberedStyleRange != null) {
            if (viewer instanceof ITextViewerExtension2) {
                ITextViewerExtension2 viewer2 = (ITextViewerExtension2)viewer;
                if (viewer instanceof ITextViewerExtension5) {
                    ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
                    IRegion widgetRange = extension.modelRange2WidgetRange((IRegion)new Region(this.fRememberedStyleRange.start, this.fRememberedStyleRange.length));
                    if (widgetRange != null) {
                        viewer2.invalidateTextPresentation(widgetRange.getOffset(), widgetRange.getLength());
                    }
                } else {
                    viewer2.invalidateTextPresentation(this.fRememberedStyleRange.start + viewer.getVisibleRegion().getOffset(), this.fRememberedStyleRange.length);
                }
            } else {
                viewer.invalidateTextPresentation();
            }
        }
    }

    private void updateStyle(ITextViewer viewer) {
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = text.getCaretOffset();
        int modelCaret = 0;
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            modelCaret = extension.widgetOffset2ModelOffset(widgetCaret);
        } else {
            IRegion visibleRegion = viewer.getVisibleRegion();
            modelCaret = widgetCaret + visibleRegion.getOffset();
        }
        if (modelCaret >= this.fReplacementOffset + this.fReplacementLength) {
            this.repairPresentation(viewer);
            return;
        }
        int offset = widgetCaret;
        int length = this.fReplacementOffset + this.fReplacementLength - modelCaret;
        Color foreground = CCompletionProposal.getForegroundColor(text);
        Color background = CCompletionProposal.getBackgroundColor(text);
        StyleRange range = text.getStyleRangeAtOffset(offset);
        int fontStyle = range != null ? range.fontStyle : 0;
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = new StyleRange(offset, length, foreground, background, fontStyle);
        try {
            text.setStyleRange(this.fRememberedStyleRange);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.fRememberedStyleRange = null;
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (!CCompletionProposal.insertCompletion() ^ smartToggle) {
            this.updateStyle(viewer);
        } else {
            this.repairPresentation(viewer);
            this.fRememberedStyleRange = null;
        }
    }

    public void unselected(ITextViewer viewer) {
        this.repairPresentation(viewer);
        this.fRememberedStyleRange = null;
    }

    public IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public void updateReplacementOffset(int newOffset) {
        this.setReplacementOffset(newOffset);
    }

    public void updateReplacementLength(int length) {
        this.setReplacementLength(length);
    }

    public int hashCode() {
        return this.fDisplayString.hashCode() + this.fReplacementString.hashCode() + (this.fContextInformation == null ? 0 : this.fContextInformation.hashCode());
    }

    public boolean equals(Object other) {
        if (!(other instanceof CCompletionProposal)) {
            return false;
        }
        if (!this.fDisplayString.equals(((CCompletionProposal)other).fDisplayString)) {
            return false;
        }
        if (!this.fReplacementString.equals(((CCompletionProposal)other).fReplacementString)) {
            return false;
        }
        return this.fContextInformation == null || ((CCompletionProposal)other).fContextInformation == null || this.fContextInformation.equals((Object)((CCompletionProposal)other).fContextInformation);
    }

    private static final class ReferenceTracker {
        private static final String CATEGORY = "reference_position";
        private final IPositionUpdater fPositionUpdater = new DefaultPositionUpdater("reference_position");
        private final Position fPosition = new Position(0);

        ReferenceTracker() {
        }

        public void preReplace(IDocument document, int offset) throws BadLocationException {
            this.fPosition.setOffset(offset);
            try {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(this.fPositionUpdater);
                document.addPosition(CATEGORY, this.fPosition);
            }
            catch (BadPositionCategoryException e) {
                CUIPlugin.getDefault().log(e);
            }
        }

        public int postReplace(IDocument document) {
            try {
                document.removePosition(CATEGORY, this.fPosition);
                document.removePositionUpdater(this.fPositionUpdater);
                document.removePositionCategory(CATEGORY);
            }
            catch (BadPositionCategoryException e) {
                CUIPlugin.getDefault().log(e);
            }
            return this.fPosition.getOffset();
        }
    }

    protected static class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;

        public ExitPolicy(char exitCharacter) {
            this.fExitCharacter = exitCharacter;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel environment, VerifyEvent event, int offset, int length) {
            if (event.character == this.fExitCharacter) {
                if (environment.anyPositionContains(offset)) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
                return new LinkedModeUI.ExitFlags(2, true);
            }
            switch (event.character) {
                case ';': {
                    return new LinkedModeUI.ExitFlags(0, true);
                }
            }
            return null;
        }
    }
}

