/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import org.eclipse.jface.util.Assert;

public class TwoArrayQuickSort {
    private static void internalSort(String[] keys, Object[] values, int left, int right, boolean ignoreCase) {
        int original_left = left;
        int original_right = right;
        String mid = keys[(left + right) / 2];
        while (true) {
            if (TwoArrayQuickSort.smaller(keys[left], mid, ignoreCase)) {
                ++left;
                continue;
            }
            while (TwoArrayQuickSort.smaller(mid, keys[right], ignoreCase)) {
                --right;
            }
            if (left <= right) {
                String tmp = keys[left];
                keys[left] = keys[right];
                keys[right] = tmp;
                Object tmp2 = values[left];
                values[left] = values[right];
                values[right] = tmp2;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            TwoArrayQuickSort.internalSort(keys, values, original_left, right, ignoreCase);
        }
        if (left < original_right) {
            TwoArrayQuickSort.internalSort(keys, values, left, original_right, ignoreCase);
        }
    }

    private static boolean smaller(String left, String right, boolean ignoreCase) {
        if (ignoreCase) {
            return left.compareToIgnoreCase(right) < 0;
        }
        return left.compareTo(right) < 0;
    }

    public static void sort(String[] keys, Object[] values, boolean ignoreCase) {
        if (keys != null && values != null) {
            Assert.isTrue((keys.length == values.length ? 1 : 0) != 0);
            if (keys.length > 1) {
                TwoArrayQuickSort.internalSort(keys, values, 0, keys.length - 1, ignoreCase);
            }
        } else if (keys != null || values != null) {
            Assert.isTrue((boolean)false, (String)"Either keys or values in null");
        }
    }
}

