/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.ast.complete;

import java.util.List;
import org.eclipse.cdt.core.parser.ISourceElementRequestor;
import org.eclipse.cdt.core.parser.ast.ASTNotImplementedException;
import org.eclipse.cdt.core.parser.ast.IASTAbstractDeclaration;
import org.eclipse.cdt.core.parser.ast.IASTSimpleTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypeSpecifier;
import org.eclipse.cdt.core.parser.ast.IASTTypedefDeclaration;
import org.eclipse.cdt.internal.core.parser.Parser;
import org.eclipse.cdt.internal.core.parser.ast.ASTQualifiedNamedElement;
import org.eclipse.cdt.internal.core.parser.ast.complete.ASTSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;

public class ASTTypedef
extends ASTSymbol
implements IASTTypedefDeclaration {
    private final IASTAbstractDeclaration mapping;
    private final ASTQualifiedNamedElement qualifiedName;
    private List references;
    private final char[] fn;
    private int startingLineNumber;
    private int startingOffset;
    private int endingLineNumber;
    private int endingOffset;
    private int nameStartOffset;
    private int nameEndOffset;
    private int nameLineNumber;

    public char[] getFilename() {
        return this.fn;
    }

    public ASTTypedef(ISymbol newSymbol, IASTAbstractDeclaration mapping, int startingOffset, int startingLine, int nameOffset, int nameEndOffset, int nameLine, List references, char[] filename) {
        super(newSymbol);
        this.mapping = mapping;
        this.references = references;
        this.qualifiedName = new ASTQualifiedNamedElement(this.getOwnerScope(), newSymbol.getName());
        this.setStartingOffsetAndLineNumber(startingOffset, startingLine);
        this.setNameOffset(nameOffset);
        this.setNameEndOffsetAndLineNumber(nameEndOffset, nameLine);
        this.fn = filename;
    }

    public String getName() {
        return String.valueOf(this.getSymbol().getName());
    }

    public IASTAbstractDeclaration getAbstractDeclarator() {
        return this.mapping;
    }

    public void acceptElement(ISourceElementRequestor requestor) {
        try {
            requestor.acceptTypedefDeclaration(this);
        }
        catch (Exception exception) {}
        Parser.processReferences(this.references, requestor);
        this.references = null;
        this.getAbstractDeclarator().acceptElement(requestor);
    }

    public void enterScope(ISourceElementRequestor requestor) {
    }

    public void exitScope(ISourceElementRequestor requestor) {
    }

    public String[] getFullyQualifiedName() {
        return this.qualifiedName.getFullyQualifiedName();
    }

    public char[][] getFullyQualifiedNameCharArrays() {
        return this.qualifiedName.getFullyQualifiedNameCharArrays();
    }

    public IASTTypeSpecifier getFinalTypeSpecifier() throws ASTNotImplementedException {
        IASTTypeSpecifier currentTypeSpec = this.mapping.getTypeSpecifier();
        while (currentTypeSpec instanceof IASTSimpleTypeSpecifier || currentTypeSpec instanceof IASTTypedefDeclaration) {
            if (currentTypeSpec instanceof IASTSimpleTypeSpecifier) {
                IASTSimpleTypeSpecifier simpleTypeSpec = (IASTSimpleTypeSpecifier)currentTypeSpec;
                if (simpleTypeSpec.getType() != IASTSimpleTypeSpecifier.Type.CLASS_OR_TYPENAME) break;
                currentTypeSpec = simpleTypeSpec.getTypeSpecifier();
                continue;
            }
            if (!(currentTypeSpec instanceof IASTTypedefDeclaration)) continue;
            currentTypeSpec = ((IASTTypedefDeclaration)currentTypeSpec).getAbstractDeclarator().getTypeSpecifier();
        }
        return currentTypeSpec;
    }

    public int getStartingLine() {
        return this.startingLineNumber;
    }

    public int getEndingLine() {
        return this.endingLineNumber;
    }

    public int getNameLineNumber() {
        return this.nameLineNumber;
    }

    public void setStartingOffsetAndLineNumber(int offset, int lineNumber) {
        this.startingOffset = offset;
        this.startingLineNumber = lineNumber;
    }

    public void setEndingOffsetAndLineNumber(int offset, int lineNumber) {
        this.endingOffset = offset;
        this.endingLineNumber = lineNumber;
    }

    public int getStartingOffset() {
        return this.startingOffset;
    }

    public int getEndingOffset() {
        return this.endingOffset;
    }

    public int getNameOffset() {
        return this.nameStartOffset;
    }

    public void setNameOffset(int o) {
        this.nameStartOffset = o;
    }

    public int getNameEndOffset() {
        return this.nameEndOffset;
    }

    public void setNameEndOffsetAndLineNumber(int offset, int lineNumber) {
        this.nameEndOffset = offset;
        this.nameLineNumber = lineNumber;
    }

    public char[] getNameCharArray() {
        return this.getSymbol().getName();
    }
}

