/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.browser.AllTypesCache;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.ITypeSearchScope;
import org.eclipse.cdt.core.browser.TypeSearchScope;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.OpenTypeHierarchyUtil;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.OpenTypeInHierarchyDialog;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class OpenTypeInHierarchyAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public void run(IAction action) {
        Object[] elements;
        TypeSearchScope fScope = new TypeSearchScope(true);
        if (!AllTypesCache.isCacheUpToDate((ITypeSearchScope)fScope)) {
            IRunnableWithProgress runnable = new IRunnableWithProgress((ITypeSearchScope)fScope){
                private final /* synthetic */ ITypeSearchScope val$fScope;
                {
                    this.val$fScope = iTypeSearchScope;
                }

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    AllTypesCache.updateCache((ITypeSearchScope)this.val$fScope, (IProgressMonitor)monitor);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            };
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                String title = OpenTypeMessages.getString("OpenTypeAction.exception.title");
                String message = OpenTypeMessages.getString("OpenTypeAction.exception.message");
                ExceptionHandler.handle(e, title, message);
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        if ((elements = AllTypesCache.getAllTypes()).length == 0) {
            String title = OpenTypeMessages.getString("OpenTypeAction.notypes.title");
            String message = OpenTypeMessages.getString("OpenTypeAction.notypes.message");
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        OpenTypeInHierarchyDialog dialog = new OpenTypeInHierarchyDialog(this.getShell());
        dialog.setElements(elements);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        ITypeInfo info = (ITypeInfo)dialog.getFirstResult();
        if (info == null) {
            return;
        }
        ICElement celem = AllTypesCache.getElementForType((ITypeInfo)info, (boolean)false, (boolean)true, null);
        if (celem != null) {
            OpenTypeHierarchyUtil.open(new ICElement[]{celem}, this.fWindow);
        }
    }

    protected Shell getShell() {
        return CUIPlugin.getActiveWorkbenchShell();
    }

    public void dispose() {
        this.fWindow = null;
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

