/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class NumberRule
implements IRule {
    private IToken token;

    public NumberRule(IToken token) {
        this.token = token;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        int startCh = scanner.read();
        if (this.isNumberStart(startCh)) {
            int ch = scanner.read();
            boolean hexNumber = ch == 120;
            boolean decNumber = false;
            if (!hexNumber) {
                decNumber = Character.isDigit((char)ch);
            }
            if (!hexNumber && !decNumber) {
                scanner.unread();
                if (startCh == 45) {
                    scanner.unread();
                    return Token.UNDEFINED;
                }
                return this.token;
            }
            if (hexNumber) {
                while (this.isHexNumberPart((char)(ch = scanner.read()))) {
                }
            } else if (decNumber) {
                while (Character.isDigit((char)(ch = scanner.read()))) {
                }
            }
            scanner.unread();
            return this.token;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    private boolean isNumberStart(int ch) {
        return ch == 45 || Character.isDigit((char)ch);
    }

    private boolean isHexNumberPart(int ch) {
        return Character.isDigit((char)ch) || ch == 97 || ch == 98 || ch == 99 || ch == 100 || ch == 101 || ch == 102 || ch == 65 || ch == 66 || ch == 67 || ch == 68 || ch == 69 || ch == 70;
    }
}

