/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.cdt.internal.ui.util.SelectionUtil;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.help.WorkbenchHelp;

public class FocusOnSelectionAction
extends Action {
    private TypeHierarchyViewPart fViewPart;

    public FocusOnSelectionAction(TypeHierarchyViewPart part) {
        super(TypeHierarchyMessages.getString("FocusOnSelectionAction.label"));
        this.setDescription(TypeHierarchyMessages.getString("FocusOnSelectionAction.description"));
        this.setToolTipText(TypeHierarchyMessages.getString("FocusOnSelectionAction.tooltip"));
        this.fViewPart = part;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.focus_on_selection_action");
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fViewPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof ICElement) {
            this.fViewPart.setInputElement((ICElement)element);
        }
    }

    public boolean canActionBeAdded() {
        Object element = SelectionUtil.getSingleElement(this.getSelection());
        if (element instanceof ICElement) {
            ICElement type = (ICElement)element;
            this.setText(TypeHierarchyMessages.getFormattedString("FocusOnSelectionAction.label", CElementLabels.getTextLabel(type, 0)));
            return true;
        }
        return false;
    }
}

