/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.HistoryAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.HistoryListAction;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyMessages;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyViewPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class HistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private TypeHierarchyViewPart fHierarchyView;
    private Menu fMenu;

    public HistoryDropDownAction(TypeHierarchyViewPart view) {
        this.fHierarchyView = view;
        this.fMenu = null;
        this.setToolTipText(TypeHierarchyMessages.getString("HistoryDropDownAction.tooltip"));
        CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "history_list.gif");
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.typehierarchy_history_action");
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        ICElement[] elements = this.fHierarchyView.getHistoryEntries();
        boolean checked = this.addEntries(this.fMenu, elements);
        if (elements.length > 10) {
            new MenuItem(this.fMenu, 2);
            HistoryListAction others = new HistoryListAction(this.fHierarchyView);
            others.setChecked(checked);
            this.addActionToMenu(this.fMenu, others);
        }
        return this.fMenu;
    }

    private boolean addEntries(Menu menu, ICElement[] elements) {
        boolean checked = false;
        int min = Math.min(elements.length, 10);
        int i = 0;
        while (i < min) {
            HistoryAction action = new HistoryAction(this.fHierarchyView, elements[i]);
            action.setChecked(elements[i].equals(this.fHierarchyView.getInputElement()));
            checked = checked || action.isChecked();
            this.addActionToMenu(menu, action);
            ++i;
        }
        return checked;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new HistoryListAction(this.fHierarchyView).run();
    }
}

