/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMember;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
    }

    public final void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        ArrayList types = new ArrayList();
        this.getRootTypes(types);
        int i = types.size() - 1;
        while (i >= 0) {
            ICElement curr = (ICElement)types.get(i);
            try {
                if (!this.isInTree(curr)) {
                    types.remove(i);
                }
            }
            catch (CModelException cModelException) {}
            --i;
        }
        return types.toArray();
    }

    protected void getRootTypes(List res) {
        ICElement input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            res.add(input);
        }
    }

    protected abstract void getTypesInHierarchy(ICElement var1, List var2);

    protected abstract ICElement[] getParentTypes(ICElement var1);

    private boolean isInScope(ICElement type) {
        return this.fWorkingSetFilter == null || this.fWorkingSetFilter.select(null, null, (Object)type);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof ICElement) {
            try {
                ICElement type = (ICElement)element;
                ArrayList children = new ArrayList();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(type, children);
                }
                this.addTypeChildren(type, children);
                return children.toArray();
            }
            catch (CModelException cModelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ICElement) {
            try {
                ICElement type = (ICElement)element;
                return this.hasTypeChildren(type) || this.fMemberFilter != null && this.hasMemberFilterChildren(type);
            }
            catch (CModelException cModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMemberChildren(ICElement parent, List children) throws CModelException {
        IMethodDeclaration[] methods = TypeUtil.getMethods((ICElement)parent);
        if (methods != null && methods.length > 0) {
            int i = 0;
            while (i < this.fMemberFilter.length) {
                IMethodDeclaration curr;
                IMethodDeclaration meth;
                IMember member = this.fMemberFilter[i];
                if (parent.equals(TypeUtil.getDeclaringClass((ICElement)member))) {
                    if (!children.contains(member)) {
                        children.add(member);
                    }
                } else if (member instanceof IMethodDeclaration && (meth = TypeUtil.findMethod((String)(curr = (IMethodDeclaration)member).getElementName(), (String[])curr.getParameterTypes(), (boolean)curr.isConstructor(), (boolean)curr.isDestructor(), (IMethodDeclaration[])methods)) != null && !children.contains(meth)) {
                    children.add(meth);
                }
                ++i;
            }
        }
    }

    private void addTypeChildren(ICElement type, List children) throws CModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            ICElement curr = (ICElement)types.get(i);
            if (this.isInTree(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    protected final boolean isInTree(ICElement type) throws CModelException {
        if (this.isInScope(type)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(type) || this.hasTypeChildren(type);
            }
            return true;
        }
        return this.hasTypeChildren(type);
    }

    private boolean hasMemberFilterChildren(ICElement type) throws CModelException {
        IMethodDeclaration[] methods = TypeUtil.getMethods((ICElement)type);
        if (methods != null && methods.length > 0) {
            int i = 0;
            while (i < this.fMemberFilter.length) {
                IMethodDeclaration curr;
                IMethodDeclaration meth;
                IMember member = this.fMemberFilter[i];
                if (type.equals(TypeUtil.getDeclaringClass((ICElement)member))) {
                    return true;
                }
                if (member instanceof IMethodDeclaration && (meth = TypeUtil.findMethod((String)(curr = (IMethodDeclaration)member).getElementName(), (String[])curr.getParameterTypes(), (boolean)curr.isConstructor(), (boolean)curr.isDestructor(), (IMethodDeclaration[])methods)) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasTypeChildren(ICElement type) throws CModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            ICElement curr = (ICElement)types.get(i);
            if (this.isInTree(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            ICElement[] parents;
            IMember member = (IMember)element;
            if (TypeUtil.isClassOrStruct((ICElement)member) && (parents = this.getParentTypes((ICElement)member)) != null && parents.length == 1) {
                return parents[0];
            }
            return TypeUtil.getDeclaringClass((ICElement)member);
        }
        return null;
    }
}

