/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.cdt.internal.ui.text.AbstractCScanner;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.util.PropertyChangeEvent;

public class CCommentScanner
extends AbstractCScanner {
    private static final String TRANSLATION_TASK_TAGS = "org.eclipse.cdt.core.translation.taskTags";
    protected static final String TASK_TAG = "c_comment_task_tag";
    private TaskTagRule fTaskTagRule;
    private Preferences fCorePreferenceStore;
    private String fDefaultTokenProperty;
    private String[] fTokenProperties;

    public CCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty) {
        this(manager, store, coreStore, defaultTokenProperty, new String[]{defaultTokenProperty, TASK_TAG});
    }

    public CCommentScanner(IColorManager manager, IPreferenceStore store, Preferences coreStore, String defaultTokenProperty, String[] tokenProperties) {
        super(manager, store);
        this.fCorePreferenceStore = coreStore;
        this.fDefaultTokenProperty = defaultTokenProperty;
        this.fTokenProperties = tokenProperties;
        this.initialize();
    }

    protected List createRules() {
        ArrayList<TaskTagRule> list = new ArrayList<TaskTagRule>();
        if (this.fCorePreferenceStore != null) {
            this.fTaskTagRule = new TaskTagRule((IToken)this.getToken(TASK_TAG));
            String tasks = this.fCorePreferenceStore.getString(TRANSLATION_TASK_TAGS);
            this.fTaskTagRule.addTaskTags(tasks);
            list.add(this.fTaskTagRule);
        }
        this.setDefaultReturnToken((IToken)this.getToken(this.fDefaultTokenProperty));
        return list;
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return event.getProperty().equals(TRANSLATION_TASK_TAGS) || super.affectsBehavior(event);
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTaskTagRule != null && event.getProperty().equals(TRANSLATION_TASK_TAGS)) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                this.fTaskTagRule.clearTaskTags();
                this.fTaskTagRule.addTaskTags((String)value);
            }
        } else if (super.affectsBehavior(event)) {
            super.adaptToPreferenceChange(event);
        }
    }

    protected String[] getTokenProperties() {
        return this.fTokenProperties;
    }

    private static class TaskTagDetector
    implements IWordDetector {
        TaskTagDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isLetter(c);
        }

        public boolean isWordPart(char c) {
            return Character.isLetter(c);
        }
    }

    private class TaskTagRule
    extends WordRule {
        private IToken fToken;

        public TaskTagRule(IToken token) {
            super((IWordDetector)new TaskTagDetector(), Token.UNDEFINED);
            this.fToken = token;
        }

        public void clearTaskTags() {
            this.fWords.clear();
        }

        public void addTaskTags(String value) {
            String[] tasks = this.split(value, ",");
            int i = 0;
            while (i < tasks.length) {
                if (tasks[i].length() > 0) {
                    this.addWord(tasks[i], this.fToken);
                }
                ++i;
            }
        }

        private String[] split(String value, String delimiters) {
            StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
            int size = tokenizer.countTokens();
            String[] tokens = new String[size];
            int i = 0;
            while (i < size) {
                tokens[i++] = tokenizer.nextToken();
            }
            return tokens;
        }
    }
}

