/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.ICAnnotation;
import org.eclipse.cdt.internal.ui.editor.IProblemAnnotation;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.SearchUI;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class CMarkerAnnotation
extends MarkerAnnotation
implements IProblemAnnotation,
ICAnnotation {
    public static final String C_MARKER_TYPE_PREFIX = "org.eclipse.cdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.cdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.cdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.eclipse.cdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private boolean fIsProblemMarker;
    private IDocument fDocument;
    private int error_start = -1;
    private int error_length = 0;
    private ICAnnotation fOverlay;

    public CMarkerAnnotation(IMarker marker, IDocument document) {
        super(marker);
        this.fDocument = document;
        if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
            this.fIsProblemMarker = true;
            try {
                int line;
                String var = (String)this.getMarker().getAttribute("problem.variable");
                if (var != null && this.fDocument != null && (line = this.getMarker().getAttribute("location", -1) - 1) >= 0) {
                    int position = this.fDocument.getLineOffset(line);
                    String text = this.fDocument.get(position, this.fDocument.getLineLength(line));
                    int start = 0;
                    int pos = 0;
                    while (start != -1) {
                        start = this.getStart(text, var, pos);
                        if (start >= 0 && !Character.isJavaIdentifierStart(text.charAt(start + var.length()))) break;
                        pos += var.length();
                    }
                    if (start >= 0) {
                        int end = start + var.length();
                        Map map = marker.getAttributes();
                        MarkerUtilities.setCharStart((Map)map, (int)(position + start));
                        MarkerUtilities.setCharEnd((Map)map, (int)(position + end));
                        this.error_start = position + start;
                        this.error_length = end - start;
                    }
                }
            }
            catch (CoreException coreException) {
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    private int getStart(String text, String var, int pos) {
        int count = 0;
        int currentPosition = pos;
        while (currentPosition != -1) {
            if ((currentPosition = text.indexOf(var, currentPosition)) == -1) continue;
            ++count;
            currentPosition += var.length();
        }
        if (count == 1) {
            return text.indexOf(var, pos);
        }
        int indexOfStringStart = pos;
        indexOfStringStart = text.indexOf("\"", indexOfStringStart);
        int newPosition = -1;
        currentPosition = pos;
        if (indexOfStringStart == -1) {
            newPosition = text.indexOf(var, currentPosition);
        } else {
            StringTokenizer tokens = new StringTokenizer(text.substring(currentPosition), "\"", true);
            String nextToken = null;
            int quoteCount = 0;
            int potentialStart = -1;
            boolean found = false;
            while (tokens.hasMoreTokens() && !found) {
                nextToken = tokens.nextToken();
                if ("\"".equals(nextToken)) {
                    ++quoteCount;
                } else if (quoteCount % 2 == 0 && (potentialStart = nextToken.indexOf(var, 0)) != -1) {
                    found = true;
                    newPosition = currentPosition += potentialStart;
                    break;
                }
                currentPosition += nextToken.length();
            }
        }
        return newPosition;
    }

    protected void initialize() {
        try {
            IMarker marker = this.getMarker();
            if (MarkerUtilities.isMarkerType((IMarker)marker, (String)"org.eclipse.search.searchmarker")) {
                this.setLayer(2);
                this.setImage(SearchUI.getSearchMarkerImage());
                this.fIsProblemMarker = false;
                return;
            }
            if (MarkerUtilities.isMarkerType((IMarker)this.getMarker(), (String)"org.eclipse.cdt.core.problem")) {
                int line;
                this.fIsProblemMarker = true;
                String var = (String)marker.getAttribute("problem.variable");
                if (var != null && this.fDocument != null && (line = marker.getAttribute("location", -1)) >= 0 && line == -1) {
                    try {
                        int position = this.fDocument.getLineOffset(line);
                        System.out.println("offset " + position);
                        String text = this.fDocument.get(position, this.fDocument.getLineLength(line));
                        System.out.println("text:" + text);
                    }
                    catch (BadLocationException badLocationException) {}
                }
            } else {
                this.fIsProblemMarker = marker.isSubtypeOf("org.eclipse.cdt.core.problem") ? true : !marker.isSubtypeOf("org.eclipse.core.resources.taskmarker") && !marker.isSubtypeOf("org.eclipse.cdt.core.task");
            }
        }
        catch (CoreException coreException) {}
        super.initialize();
    }

    public String getMessage() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("message", "");
        }
        return "";
    }

    public boolean isError() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 2;
        }
        return false;
    }

    public boolean isWarning() {
        if (this.fIsProblemMarker) {
            int markerSeverity = this.getMarker().getAttribute("severity", -1);
            return markerSeverity == 1;
        }
        return false;
    }

    public boolean isTemporaryProblem() {
        return false;
    }

    public String[] getArguments() {
        String[] s = new String[]{"problem", "here"};
        return s;
    }

    public int getId() {
        if (this.fIsProblemMarker) {
            return this.getMarker().getAttribute("org.eclipse.cdt.core.problem", -1);
        }
        return 0;
    }

    public boolean isProblem() {
        return this.fIsProblemMarker;
    }

    public int getErrorStart() {
        return this.error_start;
    }

    public int getErrorLength() {
        return this.error_length;
    }

    public void setOverlay(ICAnnotation cAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = cAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public ICAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(ICAnnotation annotation) {
    }

    public void removeOverlaid(ICAnnotation annotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ITranslationUnit getTranslationUnit() {
        ICElement element = CoreModel.getDefault().create(this.getMarker().getResource());
        if (element instanceof ITranslationUnit) {
            return (ITranslationUnit)element;
        }
        return null;
    }

    public Image getImage(Display display) {
        return super.getImage(display);
    }
}

