/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search.actions;

import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.core.search.ICSearchScope;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchScopeFactory;
import org.eclipse.cdt.internal.ui.search.CSearchUtil;
import org.eclipse.cdt.internal.ui.search.actions.FindAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;

public class FindRefsInWorkingSetAction
extends FindAction {
    private IWorkingSet[] fWorkingSet;
    private String scopeDescription = "";

    public FindRefsInWorkingSetAction(CEditor editor, IWorkingSet[] workingSets) {
        this(editor, CSearchMessages.getString("CSearch.FindReferencesInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindReferencesInWorkingSetAction.tooltip"));
        if (workingSets != null) {
            this.fWorkingSet = workingSets;
        }
    }

    public FindRefsInWorkingSetAction(IWorkbenchSite site, IWorkingSet[] workingSets) {
        this(site, CSearchMessages.getString("CSearch.FindReferencesInWorkingSetAction.label"), CSearchMessages.getString("CSearch.FindReferencesInWorkingSetAction.tooltip"));
        if (workingSets != null) {
            this.fWorkingSet = workingSets;
        }
    }

    public FindRefsInWorkingSetAction(CEditor editor, String label, String tooltip) {
        super(editor);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    public FindRefsInWorkingSetAction(IWorkbenchSite site, String label, String tooltip) {
        super(site);
        this.setText(label);
        this.setToolTipText(tooltip);
    }

    protected ICSearchConstants.LimitTo getLimitTo() {
        return ICSearchConstants.REFERENCES;
    }

    protected String getScopeDescription() {
        return this.scopeDescription;
    }

    protected ICSearchScope getScope() {
        IWorkingSet[] workingSets = null;
        if (this.fWorkingSet == null) {
            workingSets = CSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets == null) {
                return null;
            }
        } else {
            workingSets = this.fWorkingSet;
        }
        ICSearchScope scope = CSearchScopeFactory.getInstance().createCSearchScope(workingSets);
        this.scopeDescription = CSearchMessages.getFormattedString("WorkingSetScope", new String[]{CSearchUtil.toString(workingSets)});
        CSearchUtil.updateLRUWorkingSets(workingSets);
        return scope;
    }
}

