/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICExtensionReference;
import org.eclipse.cdt.ui.dialogs.IndexerBlock;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IndexerOptionPropertyPage
extends PropertyPage {
    private IndexerBlock optionPage = new IndexerBlock();
    private String oldIndexerID;
    private boolean requestedIndexAll = false;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        this.optionPage.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.cdt.ui.std_prop_indexer");
        this.initialize();
        return composite;
    }

    protected void performDefaults() {
        IProject tempProject = this.getProject();
        this.optionPage.resetIndexerPageSettings(tempProject);
    }

    private void initialize() {
        IProject project = this.getProject();
        try {
            this.oldIndexerID = this.getIndexerID(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.optionPage.setIndexerID(this.oldIndexerID, project);
    }

    public boolean performOk() {
        IProject tempProject = this.getProject();
        try {
            this.optionPage.persistIndexerSettings(tempProject, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        return true;
    }

    public IProject getProject() {
        IAdaptable tempElement = this.getElement();
        IProject project = null;
        if (tempElement != null && tempElement instanceof IProject) {
            project = (IProject)tempElement;
        }
        return project;
    }

    public String getIndexerID(IProject project) throws CoreException {
        ICDescriptor desc = CCorePlugin.getDefault().getCProjectDescription(project, true);
        ICExtensionReference[] ref = desc.get("org.eclipse.cdt.core.CIndexer");
        String indexerID = null;
        int i = 0;
        while (i < ref.length) {
            indexerID = ref[i].getID();
            ++i;
        }
        return indexerID;
    }

    private String loadIndexerIDFromCDescriptor(IProject project) throws CoreException {
        ICDescriptor descriptor = CCorePlugin.getDefault().getCProjectDescription(project, true);
        Node child = descriptor.getProjectData("cdt_indexer").getFirstChild();
        String indexerID = "";
        while (child != null) {
            if (child.getNodeName().equals("indexerUI")) {
                indexerID = ((Element)child).getAttribute("indexerUIValue");
            }
            child = child.getNextSibling();
        }
        return indexerID;
    }
}

