/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import org.eclipse.cdt.internal.core.CharOperation;
import org.eclipse.cdt.internal.core.index.IEntryResult;
import org.eclipse.cdt.internal.core.index.cindexstorage.ICIndexStorageConstants;
import org.eclipse.cdt.internal.core.index.cindexstorage.Index;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.cdt.internal.core.search.processing.JobManager;

public class EntryResult
implements IEntryResult {
    private int[] fileRefs;
    private int[][] offsets;
    private int[][] offsetLengths;
    private int meta_type;
    private int kind;
    private int reftype;
    private String longname;

    public EntryResult(char[] word, int[] refs, int[][] offsets, int[][] offsetLengths) {
        this.fileRefs = refs;
        this.offsets = offsets;
        this.offsetLengths = offsetLengths;
        this.decode(word);
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject != null && anObject instanceof EntryResult) {
            EntryResult anEntryResult = (EntryResult)anObject;
            if (this.meta_type != anEntryResult.meta_type || this.kind != anEntryResult.kind || this.reftype != anEntryResult.reftype || !this.longname.equals(anEntryResult.longname)) {
                return false;
            }
            int[] refs = this.fileRefs;
            int length = this.fileRefs.length;
            int[] otherRefs = anEntryResult.fileRefs;
            if (length != anEntryResult.fileRefs.length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (refs[i] != otherRefs[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int[] getFileReferences() {
        return this.fileRefs;
    }

    public char[] getWord() {
        return Index.encodeEntry(this.meta_type, this.kind, this.reftype, this.longname);
    }

    public int hashCode() {
        return CharOperation.hashCode(this.getWord());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("EntryResult: " + this.getName() + "\n\tmeta=");
        buffer.append(ICIndexStorageConstants.encodings[this.meta_type]);
        if (this.meta_type == 1) {
            buffer.append(" type=");
            buffer.append(ICIndexStorageConstants.typeConstantNames[this.kind]);
        }
        buffer.append(" Reference=");
        buffer.append(ICIndexStorageConstants.encodingTypes[this.reftype]);
        buffer.append(", refs={");
        int i = 0;
        while (i < this.fileRefs.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(' ');
            buffer.append(this.fileRefs[i]);
            ++i;
        }
        buffer.append(" }, offsets={");
        i = 0;
        while (i < this.offsets.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(' ');
            buffer.append('[');
            int j = 0;
            while (j < this.offsets[i].length) {
                if (j > 0) {
                    buffer.append(',');
                }
                buffer.append(' ');
                buffer.append(this.offsets[i][j]);
                ++j;
            }
            buffer.append(']');
            ++i;
        }
        buffer.append(" }\n");
        return buffer.toString();
    }

    public int[][] getOffsets() {
        return this.offsets;
    }

    public int[][] getOffsetLengths() {
        return this.offsetLengths;
    }

    public String extractSimpleName() {
        int sepPos = this.longname.indexOf(47);
        if (sepPos >= 0) {
            return this.longname.substring(0, sepPos);
        }
        return this.longname;
    }

    private void decode(char[] word) {
        int pos = 0;
        this.meta_type = 0;
        int i = 1;
        while (i < ICIndexStorageConstants.encodings.length) {
            if (CharOperation.prefixEquals(ICIndexStorageConstants.encodings[i], word)) {
                this.meta_type = i;
                pos += ICIndexStorageConstants.encodings[i].length;
                break;
            }
            ++i;
        }
        i = 1;
        while (i < ICIndexStorageConstants.encodingTypes.length) {
            if (CharOperation.fragmentEquals(ICIndexStorageConstants.encodingTypes[i], word, pos, true)) {
                this.reftype = i;
                pos += ICIndexStorageConstants.encodingTypes[i].length;
                break;
            }
            ++i;
        }
        if (this.meta_type == 1) {
            i = 1;
            while (i < Index.typeConstants.length) {
                if (word[pos] == Index.typeConstants[i]) {
                    this.kind = i;
                    ++pos;
                    break;
                }
                ++i;
            }
            if (word[pos] != '/' && IndexManager.VERBOSE) {
                JobManager.verbose("Invalid encoding encoutered while decoding Entry Result");
            }
            ++pos;
        } else {
            this.kind = 0;
        }
        this.longname = new String(word, pos, word.length - pos);
    }

    public String[] getEnclosingNames() {
        int slash = this.longname.indexOf(47);
        String[] enclosingNames = null;
        if (slash != -1 && slash + 1 < this.longname.length()) {
            char[][] temp = CharOperation.splitOn('/', CharOperation.subarray(this.longname.toCharArray(), slash + 1, -1));
            enclosingNames = new String[temp.length];
            int i = 0;
            while (i < temp.length) {
                enclosingNames[i] = String.valueOf(temp[temp.length - i - 1]);
                ++i;
            }
        }
        return enclosingNames;
    }

    public int getMetaKind() {
        return this.meta_type;
    }

    public int getKind() {
        return this.kind;
    }

    public int getRefKind() {
        return this.reftype;
    }

    public String getName() {
        return this.longname;
    }

    public String getStringMetaKind() {
        return String.valueOf(ICIndexStorageConstants.encodings[this.meta_type]);
    }

    public String getStringKind() {
        return ICIndexStorageConstants.typeConstantNames[this.kind];
    }

    public String getStringRefKind() {
        return String.valueOf(ICIndexStorageConstants.encodingTypes[this.reftype]);
    }

    public String getDisplayString() {
        switch (this.meta_type) {
            case 2: 
            case 3: {
                int startReturn = this.longname.indexOf(")R/");
                int finishReturn = this.longname.indexOf("/R(");
                int startParam = this.longname.indexOf("/)", finishReturn);
                int finishParam = this.longname.indexOf("/(", startParam);
                String arguments = "";
                if (startParam + 2 < finishParam) {
                    arguments = this.longname.substring(startParam + 3, finishParam);
                }
                arguments = arguments.replace('/', ',');
                arguments = String.valueOf('(') + arguments + ')';
                if (startReturn == -1 || finishReturn == -1) {
                    String functionName = this.longname.substring(0, startParam - 1);
                    return String.valueOf(functionName) + arguments;
                }
                String returnType = "";
                if (startReturn + 3 < finishReturn) {
                    returnType = this.longname.substring(startReturn + 3, finishReturn);
                }
                String functionName = this.longname.substring(0, startReturn - 1);
                return String.valueOf(functionName) + arguments + ':' + returnType;
            }
        }
        return this.longname;
    }
}

