/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelOperation;
import org.eclipse.cdt.internal.core.model.TranslationUnit;
import org.eclipse.cdt.internal.core.model.WorkingCopy;

public class DestroyWorkingCopyOperation
extends CModelOperation {
    public DestroyWorkingCopyOperation(ICElement workingCopy) {
        super(new ICElement[]{workingCopy});
    }

    protected void executeOperation() throws CModelException {
        WorkingCopy workingCopy = this.getWorkingCopy();
        workingCopy.close();
        ITranslationUnit originalElement = workingCopy.getOriginalElement();
        if (!workingCopy.getParent().exists()) {
            ((TranslationUnit)originalElement).close();
        }
        CModelManager manager = CModelManager.getDefault();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        Map perFactoryWorkingCopies = (Map)sharedWorkingCopies.get(workingCopy.bufferFactory);
        if (perFactoryWorkingCopies != null) {
            perFactoryWorkingCopies.remove(originalElement);
        }
        CElementDelta delta = new CElementDelta(this.getCModel());
        delta.removed(workingCopy);
        this.addDelta(delta);
        this.removeReconcileDelta(workingCopy);
    }

    protected WorkingCopy getWorkingCopy() {
        return (WorkingCopy)this.getElementToProcess();
    }

    public boolean isReadOnly() {
        return true;
    }
}

