/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage.io;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.cdt.internal.core.index.cindexstorage.IncludeEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.WordEntry;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.FileListBlock;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.GammaCompressedIndexBlock;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexBlock;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexOutput;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.IndexSummary;
import org.eclipse.cdt.internal.core.index.cindexstorage.io.SafeRandomAccessFile;

public class BlocksIndexOutput
extends IndexOutput {
    protected RandomAccessFile indexOut;
    protected int blockNum;
    protected boolean opened = false;
    protected File indexFile;
    protected FileListBlock fileListBlock;
    protected IndexBlock indexBlock;
    protected IndexBlock includeIndexBlock;
    protected int numWords = 0;
    protected int numFiles = 0;
    protected int numIncludes = 0;
    protected IndexSummary summary;
    protected boolean firstInBlock;
    protected boolean firstIndexBlock;
    protected boolean firstFileListBlock;
    protected boolean firstIncludeIndexBlock;

    public BlocksIndexOutput(File indexFile) {
        this.indexFile = indexFile;
        this.summary = new IndexSummary();
        this.blockNum = 1;
        this.firstInBlock = true;
        this.firstIndexBlock = true;
        this.firstFileListBlock = true;
        this.firstIncludeIndexBlock = true;
    }

    public void addFile(IndexedFileEntry indexedFile) throws IOException {
        if (this.firstFileListBlock) {
            this.firstInBlock = true;
            this.fileListBlock = new FileListBlock(8192);
            this.firstFileListBlock = false;
        }
        if (this.fileListBlock.addFile(indexedFile)) {
            if (this.firstInBlock) {
                this.summary.addFirstFileInBlock(indexedFile, this.blockNum);
                this.firstInBlock = false;
            }
            ++this.numFiles;
        } else {
            if (this.fileListBlock.isEmpty()) {
                return;
            }
            this.flushFiles();
            this.addFile(indexedFile);
        }
    }

    public void addWord(WordEntry entry) throws IOException {
        if (this.firstIndexBlock) {
            this.indexBlock = new GammaCompressedIndexBlock(8192);
            this.firstInBlock = true;
            this.firstIndexBlock = false;
        }
        if (entry.getNumRefs() == 0) {
            return;
        }
        if (this.indexBlock.addEntry(entry)) {
            if (this.firstInBlock) {
                this.summary.addFirstWordInBlock(entry.getWord(), this.blockNum);
                this.firstInBlock = false;
            }
            ++this.numWords;
        } else {
            if (this.indexBlock.isEmpty()) {
                return;
            }
            this.flushWords();
            this.addWord(entry);
        }
    }

    public void addInclude(IncludeEntry entry) throws IOException {
        if (this.firstIncludeIndexBlock) {
            this.includeIndexBlock = new GammaCompressedIndexBlock(8192);
            this.firstInBlock = true;
            this.firstIncludeIndexBlock = false;
        }
        if (entry.getNumRefs() == 0) {
            return;
        }
        if (this.includeIndexBlock.addIncludeEntry(entry)) {
            if (this.firstInBlock) {
                this.summary.addFirstIncludeInBlock(entry.getFile(), this.blockNum);
                this.firstInBlock = false;
            }
            ++this.numIncludes;
        } else {
            if (this.includeIndexBlock.isEmpty()) {
                return;
            }
            this.flushIncludes();
            this.addInclude(entry);
        }
    }

    public void close() throws IOException {
        if (this.opened) {
            this.indexOut.close();
            this.summary = null;
            this.numFiles = 0;
            this.opened = false;
        }
    }

    public void flush() throws IOException {
        this.summary.setNumFiles(this.numFiles);
        this.summary.setNumWords(this.numWords);
        this.summary.setNumIncludes(this.numIncludes);
        this.indexOut.seek((long)this.blockNum * 8192L);
        this.summary.write(this.indexOut);
        this.indexOut.seek(0L);
        this.indexOut.writeUTF("INDEX FILE 0.017");
        this.indexOut.writeInt(this.blockNum);
    }

    protected void flushFiles() throws IOException {
        if (!this.firstFileListBlock && this.fileListBlock != null) {
            this.fileListBlock.flush();
            this.fileListBlock.write(this.indexOut, this.blockNum++);
            this.fileListBlock.clear();
            this.firstInBlock = true;
        }
    }

    protected void flushWords() throws IOException {
        if (!this.firstInBlock && this.indexBlock != null) {
            this.indexBlock.flush();
            this.indexBlock.write(this.indexOut, this.blockNum++);
            this.indexBlock.clear();
            this.firstInBlock = true;
        }
    }

    protected void flushIncludes() throws IOException {
        if (!this.firstInBlock && this.includeIndexBlock != null) {
            this.includeIndexBlock.flush();
            this.includeIndexBlock.write(this.indexOut, this.blockNum++);
            this.includeIndexBlock.clear();
            this.firstInBlock = true;
        }
    }

    public Object getDestination() {
        return this.indexFile;
    }

    public void open() throws IOException {
        if (!this.opened) {
            this.summary = new IndexSummary();
            this.numFiles = 0;
            this.numWords = 0;
            this.numIncludes = 0;
            this.blockNum = 1;
            this.firstInBlock = true;
            this.firstIndexBlock = true;
            this.firstFileListBlock = true;
            this.firstIncludeIndexBlock = true;
            this.indexOut = new SafeRandomAccessFile(this.indexFile, "rw");
            this.opened = true;
        }
    }
}

