/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.typehierarchy;

import org.eclipse.cdt.core.browser.TypeUtil;
import org.eclipse.cdt.core.browser.typehierarchy.ITypeHierarchy;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethodDeclaration;
import org.eclipse.cdt.core.parser.ast.ASTAccessVisibility;
import org.eclipse.cdt.internal.ui.browser.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.cdt.ui.CElementSorter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class HierarchyViewerSorter
extends ViewerSorter {
    private static final int OTHER = 0;
    private static final int CLASS = 1;
    private static final int FIELD = 2;
    private static final int METHOD = 3;
    private TypeHierarchyLifeCycle fHierarchy;
    private boolean fSortByDefiningType;
    private CElementSorter fNormalSorter;

    public HierarchyViewerSorter(TypeHierarchyLifeCycle cycle) {
        this.fHierarchy = cycle;
        this.fNormalSorter = new CElementSorter();
    }

    public int category(Object obj) {
        if (obj instanceof ICElement) {
            ICElement elem = (ICElement)obj;
            switch (elem.getElementType()) {
                case 65: 
                case 67: {
                    return 1;
                }
                case 72: {
                    return 2;
                }
                case 70: 
                case 71: {
                    return 3;
                }
            }
        }
        return 0;
    }

    public boolean isSortByDefiningType() {
        return this.fSortByDefiningType;
    }

    public void setSortByDefiningType(boolean sortByDefiningType) {
        this.fSortByDefiningType = sortByDefiningType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        ITypeHierarchy hierarchy = this.fHierarchy.getHierarchy();
        if (hierarchy == null) {
            return this.fNormalSorter.compare(viewer, e1, e2);
        }
        if (cat1 == 2 || cat1 == 3) {
            if (!this.fSortByDefiningType) return this.fNormalSorter.compare(viewer, e1, e2);
            try {
                ICElement def2;
                ICElement def1 = e1 instanceof IMethodDeclaration ? this.getDefiningType(hierarchy, (IMethodDeclaration)e1) : null;
                ICElement iCElement = def2 = e2 instanceof IMethodDeclaration ? this.getDefiningType(hierarchy, (IMethodDeclaration)e2) : null;
                if (def1 != null) {
                    if (def2 == null) return -1;
                    if (def2.equals(def1)) return this.fNormalSorter.compare(viewer, e1, e2);
                    return this.compareInHierarchy(hierarchy, def1, def2);
                } else {
                    if (def2 == null) return this.fNormalSorter.compare(viewer, e1, e2);
                    return 1;
                }
            }
            catch (CModelException cModelException) {}
            return this.fNormalSorter.compare(viewer, e1, e2);
        }
        String name1 = ((ICElement)e1).getElementName();
        String name2 = ((ICElement)e2).getElementName();
        return this.getCollator().compare(name1, name2);
    }

    private ICElement getDefiningType(ITypeHierarchy hierarchy, IMethodDeclaration method) throws CModelException {
        ICElement declaringType = TypeUtil.getDeclaringClass((ICElement)method);
        if (method.getVisibility() == ASTAccessVisibility.PRIVATE || method.isStatic() || method.isConstructor() || method.isDestructor()) {
            return null;
        }
        IMethodDeclaration res = TypeUtil.findMethodDeclarationInHierarchy((ITypeHierarchy)hierarchy, (ICElement)declaringType, (String)method.getElementName(), (String[])method.getParameterTypes(), (boolean)false, (boolean)false);
        if (res == null || method.equals(res)) {
            return null;
        }
        return TypeUtil.getDeclaringClass((ICElement)res);
    }

    private int compareInHierarchy(ITypeHierarchy hierarchy, ICElement def1, ICElement def2) {
        if (this.isSuperType(hierarchy, def1, def2)) {
            return 1;
        }
        if (this.isSuperType(hierarchy, def2, def1)) {
            return -1;
        }
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getCollator().compare(name1, name2);
    }

    private boolean isSuperType(ITypeHierarchy hierarchy, ICElement def1, ICElement def2) {
        ICElement[] superTypes = hierarchy.getSupertypes(def1);
        if (superTypes != null) {
            int i = 0;
            while (i < superTypes.length) {
                if (superTypes[i].equals(def2) || this.isSuperType(hierarchy, superTypes[i], def2)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

