/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeAbortException;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IUndoManager;
import org.eclipse.cdt.internal.corext.refactoring.base.Refactoring;
import org.eclipse.cdt.internal.corext.refactoring.base.UndoManagerAdapter;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.actions.UndoManagerAction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchSite;

public class RedoRefactoringAction
extends UndoManagerAction {
    private int fPatternLength;
    private CEditor fEditor;

    public RedoRefactoringAction(CEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
    }

    public RedoRefactoringAction(IWorkbenchSite site) {
        super(site);
        this.init(site.getWorkbenchWindow());
    }

    protected String getName() {
        return RefactoringMessages.getString("RedoRefactoringAction.name");
    }

    protected IRunnableWithProgress createOperation(final ChangeContext context) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    RedoRefactoringAction.this.setPreflightStatus(Refactoring.getUndoManager().performRedo(context, pm));
                }
                catch (CModelException e) {
                    throw new InvocationTargetException(e);
                }
                catch (ChangeAbortException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    protected UndoManagerAdapter createUndoManagerListener() {
        return new UndoManagerAdapter(){

            public void redoStackChanged(IUndoManager manager) {
                IAction action = RedoRefactoringAction.this.getAction();
                if (action == null) {
                    return;
                }
                boolean enabled = false;
                String text = null;
                if (manager.anythingToRedo()) {
                    enabled = true;
                    text = RedoRefactoringAction.this.getActionText();
                } else {
                    text = RefactoringMessages.getString("RedoRefactoringAction.label");
                }
                action.setEnabled(enabled);
                action.setText(text);
            }
        };
    }

    public void selectionChanged(ISelection s) {
        this.selectionChanged((IAction)this, s);
    }

    public void selectionChanged(IAction action, ISelection s) {
        if (!this.isHooked()) {
            this.hookListener(action);
        }
        this.fPatternLength = RefactoringMessages.getString("RedoRefactoringAction.extendedLabel").length();
        IUndoManager undoManager = Refactoring.getUndoManager();
        if (undoManager.anythingToRedo()) {
            if (undoManager.peekRedoName() != null) {
                action.setText(this.getActionText());
            }
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    private String getActionText() {
        return this.shortenText(RefactoringMessages.getFormattedString("RedoRefactoringAction.extendedLabel", Refactoring.getUndoManager().peekRedoName()), this.fPatternLength);
    }
}

