/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNameOwner;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConversionName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTOperatorName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNode;

public class CPPASTQualifiedName
extends CPPASTNode
implements ICPPASTQualifiedName {
    private IASTName[] names = null;
    private int namesPos = -1;
    private boolean value;
    private String signature;
    static /* synthetic */ Class class$0;

    public IBinding resolveBinding() {
        this.removeNullNames();
        return this.names[this.names.length - 1].resolveBinding();
    }

    public IBinding[] resolvePrefix() {
        this.removeNullNames();
        return this.names[this.names.length - 1].resolvePrefix();
    }

    public String toString() {
        if (this.signature == null) {
            return "";
        }
        return this.signature;
    }

    public void addName(IASTName name) {
        if (name != null) {
            ++this.namesPos;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.names = (IASTName[])ArrayUtil.append(clazz, this.names, name);
        }
    }

    private void removeNullNames() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.core.dom.ast.IASTName");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.names = (IASTName[])ArrayUtil.removeNullsAfter(clazz, this.names, this.namesPos);
    }

    public IASTName[] getNames() {
        if (this.names == null) {
            return IASTName.EMPTY_NAME_ARRAY;
        }
        this.removeNullNames();
        return this.names;
    }

    public char[] toCharArray() {
        if (this.names == null) {
            return "".toCharArray();
        }
        this.removeNullNames();
        int len = 0;
        int i = 0;
        while (i < this.names.length) {
            char[] n = this.names[i].toCharArray();
            if (n == null) {
                return null;
            }
            len += n.length;
            if (i != this.names.length - 1) {
                len += 2;
            }
            ++i;
        }
        char[] nameArray = new char[len];
        int pos = 0;
        int i2 = 0;
        while (i2 < this.names.length) {
            char[] n = this.names[i2].toCharArray();
            System.arraycopy(n, 0, nameArray, pos, n.length);
            pos += n.length;
            if (i2 != this.names.length - 1) {
                nameArray[pos++] = 58;
                nameArray[pos++] = 58;
            }
            ++i2;
        }
        return nameArray;
    }

    public boolean isFullyQualified() {
        return this.value;
    }

    public void setFullyQualified(boolean value) {
        this.value = value;
    }

    public void setValue(String string) {
        this.signature = string;
    }

    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitNames) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTName[] ns = this.getNames();
        int i = 0;
        while (i < ns.length) {
            if (i == this.names.length - 1 ? this.names[i].toCharArray().length > 0 && !this.names[i].accept(action) : !this.names[i].accept(action)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isDeclaration() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role != 1;
        }
        return false;
    }

    public boolean isReference() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 1;
        }
        return false;
    }

    public int getRoleForName(IASTName n) {
        IASTName[] namez = this.getNames();
        int i = 0;
        while (i < this.names.length) {
            if (namez[i] == n) {
                if (i < this.names.length - 1) {
                    return 1;
                }
                IASTNode p = this.getParent();
                if (i == this.names.length - 1 && p instanceof IASTNameOwner) {
                    return ((IASTNameOwner)((Object)p)).getRoleForName(this);
                }
                return 3;
            }
            ++i;
        }
        return 3;
    }

    public IBinding getBinding() {
        this.removeNullNames();
        return this.names[this.names.length - 1].getBinding();
    }

    public void setBinding(IBinding binding) {
        this.removeNullNames();
        this.names[this.names.length - 1].setBinding(binding);
    }

    public boolean isConversionOrOperator() {
        IASTName tempName;
        int len;
        IASTName[] nonNullNames = this.getNames();
        if (nonNullNames[(len = nonNullNames.length) - 1] instanceof ICPPASTConversionName || nonNullNames[len - 1] instanceof ICPPASTOperatorName) {
            return true;
        }
        return nonNullNames[len - 1] instanceof ICPPASTTemplateId && ((tempName = ((ICPPASTTemplateId)nonNullNames[len - 1]).getTemplateName()) instanceof ICPPASTConversionName || tempName instanceof ICPPASTOperatorName);
    }

    public boolean isDefinition() {
        IASTNode parent = this.getParent();
        if (parent instanceof IASTNameOwner) {
            int role = ((IASTNameOwner)((Object)parent)).getRoleForName(this);
            return role == 2;
        }
        return false;
    }
}

