/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.cindexstorage;

import java.util.ArrayList;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexPathVariableEntry;

public final class IndexPathVariableEntryHashedArray {
    private IndexPathVariableEntry[] elements;
    private int elementSize;
    private int threshold;
    private int lastId;
    private ArrayList replacedElements;

    public IndexPathVariableEntryHashedArray(int size) {
        if (size < 7) {
            size = 7;
        }
        this.elements = new IndexPathVariableEntry[2 * size + 1];
        this.elementSize = 0;
        this.threshold = size + 1;
        this.lastId = 1;
        this.replacedElements = null;
    }

    public IndexPathVariableEntry add(String pathVarName, String path) {
        return this.add(new IndexPathVariableEntry(pathVarName, path, ++this.lastId));
    }

    private IndexPathVariableEntry add(IndexPathVariableEntry pathVar) {
        IndexPathVariableEntry current;
        int length = this.elements.length;
        String path = pathVar.getPathVariablePath();
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPathVariablePath().equals(path)) {
                if (this.replacedElements == null) {
                    this.replacedElements = new ArrayList(5);
                }
                this.replacedElements.add(current);
                this.elements[index] = pathVar;
                return this.elements[index];
            }
            if (++index != length) continue;
            index = 0;
        }
        this.elements[index] = pathVar;
        if (++this.elementSize > this.threshold) {
            this.grow();
        }
        return pathVar;
    }

    public IndexPathVariableEntry[] asArray() {
        IndexPathVariableEntry current;
        IndexPathVariableEntry[] array = new IndexPathVariableEntry[this.lastId];
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            current = this.elements[i];
            if (current != null) {
                array[current.getId() - 1] = current;
            }
            ++i;
        }
        if (this.replacedElements != null) {
            i = 0;
            length = this.replacedElements.size();
            while (i < length) {
                array[current.getId() - 1] = current = (IndexPathVariableEntry)this.replacedElements.get(i);
                ++i;
            }
        }
        return array;
    }

    public IndexPathVariableEntry get(String path) {
        IndexPathVariableEntry current;
        int length = this.elements.length;
        int index = (path.hashCode() & Integer.MAX_VALUE) % length;
        while ((current = this.elements[index]) != null) {
            if (current.getPathVariablePath().equals(path)) {
                return current;
            }
            if (++index != length) continue;
            index = 0;
        }
        return null;
    }

    private void grow() {
        IndexPathVariableEntryHashedArray newArray = new IndexPathVariableEntryHashedArray(this.elementSize * 2);
        int i = 0;
        int length = this.elements.length;
        while (i < length) {
            if (this.elements[i] != null) {
                newArray.add(this.elements[i]);
            }
            ++i;
        }
        this.elements = newArray.elements;
        this.elementSize = newArray.elementSize;
        this.threshold = newArray.threshold;
    }

    public int size() {
        return this.elementSize + (this.replacedElements == null ? 0 : this.replacedElements.size());
    }

    public String toString() {
        String s = "";
        IndexPathVariableEntry[] files = this.asArray();
        int i = 0;
        int length = files.length;
        while (i < length) {
            s = String.valueOf(s) + files[i].toString() + "\n";
            ++i;
        }
        return s;
    }
}

