/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.mi.core.cdi;

import java.util.Properties;
import org.eclipse.cdt.debug.core.cdi.CDIException;
import org.eclipse.cdt.debug.core.cdi.ICDIEventManager;
import org.eclipse.cdt.debug.core.cdi.ICDISession;
import org.eclipse.cdt.debug.core.cdi.ICDISessionConfiguration;
import org.eclipse.cdt.debug.core.cdi.ICDISessionObject;
import org.eclipse.cdt.debug.core.cdi.event.ICDIEvent;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.mi.core.MISession;
import org.eclipse.cdt.debug.mi.core.cdi.BreakpointManager;
import org.eclipse.cdt.debug.mi.core.cdi.EventManager;
import org.eclipse.cdt.debug.mi.core.cdi.ExpressionManager;
import org.eclipse.cdt.debug.mi.core.cdi.MemoryManager;
import org.eclipse.cdt.debug.mi.core.cdi.ProcessManager;
import org.eclipse.cdt.debug.mi.core.cdi.RegisterManager;
import org.eclipse.cdt.debug.mi.core.cdi.SessionConfiguration;
import org.eclipse.cdt.debug.mi.core.cdi.SharedLibraryManager;
import org.eclipse.cdt.debug.mi.core.cdi.SignalManager;
import org.eclipse.cdt.debug.mi.core.cdi.SourceManager;
import org.eclipse.cdt.debug.mi.core.cdi.VariableManager;
import org.eclipse.cdt.debug.mi.core.cdi.event.DestroyedEvent;
import org.eclipse.cdt.debug.mi.core.cdi.model.Target;

public class Session
implements ICDISession,
ICDISessionObject {
    public static final Target[] EMPTY_TARGETS = new Target[0];
    Properties props;
    ProcessManager processManager;
    EventManager eventManager;
    BreakpointManager breakpointManager;
    ExpressionManager expressionManager;
    VariableManager variableManager;
    RegisterManager registerManager;
    MemoryManager memoryManager;
    SharedLibraryManager sharedLibraryManager;
    SignalManager signalManager;
    SourceManager sourceManager;
    ICDISessionConfiguration configuration;

    public Session(MISession miSession, boolean attach) {
        this.commonSetup();
        Target target = new Target(this, miSession);
        this.addTargets(new Target[]{target});
    }

    public Session(MISession miSession) {
        this.commonSetup();
        Target target = new Target(this, miSession);
        this.addTargets(new Target[]{target});
    }

    private void commonSetup() {
        this.props = new Properties();
        this.setConfiguration(new SessionConfiguration(this));
        this.processManager = new ProcessManager(this);
        this.breakpointManager = new BreakpointManager(this);
        this.eventManager = new EventManager(this);
        this.expressionManager = new ExpressionManager(this);
        this.variableManager = new VariableManager(this);
        this.registerManager = new RegisterManager(this);
        this.memoryManager = new MemoryManager(this);
        this.signalManager = new SignalManager(this);
        this.sourceManager = new SourceManager(this);
        this.sharedLibraryManager = new SharedLibraryManager(this);
    }

    public void addTargets(Target[] targets) {
        ProcessManager pMgr = this.getProcessManager();
        pMgr.addTargets(targets);
    }

    public void removeTargets(Target[] targets) {
        ProcessManager pMgr = this.getProcessManager();
        pMgr.removeTargets(targets);
    }

    public Target getTarget(MISession miSession) {
        ProcessManager pMgr = this.getProcessManager();
        return pMgr.getTarget(miSession);
    }

    public String getAttribute(String key) {
        return this.props.getProperty(key);
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public BreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    public ICDIEventManager getEventManager() {
        return this.eventManager;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public VariableManager getVariableManager() {
        return this.variableManager;
    }

    public RegisterManager getRegisterManager() {
        return this.registerManager;
    }

    public SharedLibraryManager getSharedLibraryManager() {
        return this.sharedLibraryManager;
    }

    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public SignalManager getSignalManager() {
        return this.signalManager;
    }

    public SourceManager getSourceManager() {
        return this.sourceManager;
    }

    public ICDITarget[] getTargets() {
        ProcessManager pMgr = this.getProcessManager();
        return pMgr.getCDITargets();
    }

    public void setAttribute(String key, String value) {
        this.props.setProperty(key, value);
    }

    public ICDISessionConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ICDISessionConfiguration conf) {
        this.configuration = conf;
    }

    public ICDISession getSession() {
        return this;
    }

    public void terminate() throws CDIException {
        ProcessManager pMgr = this.getProcessManager();
        Target[] targets = pMgr.getTargets();
        int i = 0;
        while (i < targets.length) {
            if (!targets[i].getMISession().isTerminated()) {
                targets[i].getMISession().terminate();
            }
            ++i;
        }
        i = 0;
        while (i < 2) {
            targets = pMgr.getTargets();
            if (targets.length == 0) break;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        EventManager eMgr = (EventManager)this.getEventManager();
        eMgr.fireEvents(new ICDIEvent[]{new DestroyedEvent(this)});
        eMgr.removeEventListeners();
    }

    public Process getSessionProcess() throws CDIException {
        ICDITarget[] targets = this.getTargets();
        if (targets != null && targets.length > 0) {
            return this.getSessionProcess(targets[0]);
        }
        return null;
    }

    public Process getSessionProcess(ICDITarget target) {
        MISession miSession = ((Target)target).getMISession();
        return miSession.getSessionProcess();
    }
}

