/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.ui.actions;

import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIMessages;
import org.eclipse.cdt.managedbuilder.internal.ui.ManagedBuilderUIPlugin;
import org.eclipse.cdt.managedbuilder.ui.actions.ConvertTargetDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionDelegate;

public class ConvertTargetAction
extends ActionDelegate
implements IObjectActionDelegate {
    private IProject selectedProject = null;
    public static final String PREFIX = "ProjectConvert";
    public static final String PROJECT_CONVERTER_DIALOG = "ProjectConvert.title";

    public static void initStartup() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IProject) {
            IProject project = (IProject)obj;
            this.setSelectedProject(project);
            return;
        }
        this.setSelectedProject(null);
    }

    private IProjectType getProjectType(IProject project) {
        IManagedProject managedProject;
        IProjectType projectType = null;
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project);
        if (info != null && (managedProject = info.getManagedProject()) != null) {
            projectType = managedProject.getProjectType();
        }
        return projectType;
    }

    public void run(IAction action) {
        Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
        if (ManagedBuildManager.hasTargetConversionElements((IBuildObject)this.getProjectType(this.getSelectedProject()))) {
            this.handleConvertTargetAction();
        } else {
            MessageDialog.openError((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ProjectConvert.noConverterErrordialog.title"), (String)ManagedBuilderUIMessages.getFormattedString("ProjectConvert.noConverterErrordialog.message", new String[]{this.getSelectedProject().getName()}));
        }
    }

    private void handleConvertTargetAction() {
        Shell shell = ManagedBuilderUIPlugin.getDefault().getShell();
        String title = ManagedBuilderUIMessages.getFormattedString(PROJECT_CONVERTER_DIALOG, new String(this.getSelectedProject().getName()));
        ConvertTargetDialog dialog = new ConvertTargetDialog(shell, this.getSelectedProject(), title);
        if (dialog.open() == 0 && !ConvertTargetDialog.isConversionSuccessful()) {
            MessageDialog.openError((Shell)shell, (String)ManagedBuilderUIMessages.getResourceString("ProjectConvert.conversionErrordialog.title"), (String)ManagedBuilderUIMessages.getFormattedString("ProjectConvert.conversionErrordialog.message", new String[]{this.getSelectedProject().getName()}));
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    private IProject getSelectedProject() {
        return this.selectedProject;
    }

    private void setSelectedProject(IProject selectedProject) {
        this.selectedProject = selectedProject;
    }
}

