/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IProjectType;
import org.eclipse.cdt.managedbuilder.core.IResourceConfiguration;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.internal.core.BuildObject;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.Option;
import org.eclipse.cdt.managedbuilder.internal.core.ProjectType;
import org.eclipse.cdt.managedbuilder.internal.core.ResourceConfiguration;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.envvar.EnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.UserDefinedEnvironmentSupplier;
import org.eclipse.cdt.managedbuilder.internal.macros.BuildMacroProvider;
import org.eclipse.cdt.managedbuilder.internal.macros.UserDefinedMacroSupplier;
import org.eclipse.cdt.managedbuilder.macros.IConfigurationBuildMacroSupplier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Configuration
extends BuildObject
implements IConfiguration {
    private static final String EMPTY_STRING = new String();
    private IConfiguration parent;
    private ProjectType projectType;
    private ManagedProject managedProject;
    private ToolChain toolChain;
    private List resourceConfigurationList;
    private Map resourceConfigurationMap;
    private String artifactName;
    private String cleanCommand;
    private String artifactExtension;
    private String errorParserIds;
    private String prebuildStep;
    private String postbuildStep;
    private String preannouncebuildStep;
    private String postannouncebuildStep;
    private String description;
    private boolean isExtensionConfig = false;
    private boolean isDirty = false;
    private boolean rebuildNeeded = false;
    private boolean resolved = true;
    private boolean isTemporary = false;

    public Configuration(ProjectType projectType, IManagedConfigElement element, String managedBuildRevision) {
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromManifest(element);
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
        }
        IManagedConfigElement[] configElements = element.getChildren();
        int l = 0;
        while (l < configElements.length) {
            IManagedConfigElement configElement = configElements[l];
            if (configElement.getName().equals("toolChain")) {
                this.toolChain = new ToolChain((IConfiguration)this, configElement, managedBuildRevision);
            } else if (configElement.getName().equals("resourceConfiguration")) {
                ResourceConfiguration resConfig = new ResourceConfiguration((IConfiguration)this, configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            }
            ++l;
        }
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id) {
        this.setId(id);
        this.projectType = projectType;
        this.isExtensionConfig = true;
        this.resolved = false;
        if (parentConfig != null) {
            this.name = parentConfig.getName();
            this.parent = parentConfig.getParent() == null ? parentConfig : parentConfig.getParent();
        }
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ProjectType projectType, IConfiguration parentConfig, String id, String name) {
        this.setId(id);
        this.setName(name);
        this.projectType = projectType;
        this.parent = parentConfig;
        this.isExtensionConfig = true;
        ManagedBuildManager.addExtensionConfiguration(this);
        if (projectType != null) {
            projectType.addConfiguration(this);
            this.setManagedBuildRevision(projectType.getManagedBuildRevision());
        }
    }

    public Configuration(ManagedProject managedProject, Element element, String managedBuildRevision) {
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        this.setManagedBuildRevision(managedBuildRevision);
        this.loadFromProject(element);
        managedProject.addConfiguration(this);
        NodeList configElements = element.getChildNodes();
        int i = 0;
        while (i < configElements.getLength()) {
            Node configElement = configElements.item(i);
            if (configElement.getNodeName().equals("toolChain")) {
                this.toolChain = new ToolChain((IConfiguration)this, (Element)configElement, managedBuildRevision);
            } else if (configElement.getNodeName().equals("resourceConfiguration")) {
                ResourceConfiguration resConfig = new ResourceConfiguration((IConfiguration)this, (Element)configElement, managedBuildRevision);
                this.addResourceConfiguration(resConfig);
            }
            ++i;
        }
    }

    public Configuration(ManagedProject managedProject, Configuration cloneConfig, String id, boolean cloneChildren, boolean temporary) {
        String subName;
        String subId;
        this.setId(id);
        this.setName(cloneConfig.getName());
        this.description = cloneConfig.getDescription();
        this.managedProject = managedProject;
        this.isExtensionConfig = false;
        this.isTemporary = temporary;
        this.setManagedBuildRevision(cloneConfig.getManagedBuildRevision());
        this.parent = cloneConfig.getParent() == null ? cloneConfig : cloneConfig.getParent();
        this.projectType = cloneConfig.projectType;
        if (cloneConfig.artifactName != null) {
            this.artifactName = new String(cloneConfig.artifactName);
        }
        if (cloneConfig.cleanCommand != null) {
            this.cleanCommand = new String(cloneConfig.cleanCommand);
        }
        if (cloneConfig.artifactExtension != null) {
            this.artifactExtension = new String(cloneConfig.artifactExtension);
        }
        if (cloneConfig.errorParserIds != null) {
            this.errorParserIds = new String(cloneConfig.errorParserIds);
        }
        if (cloneConfig.prebuildStep != null) {
            this.prebuildStep = new String(cloneConfig.prebuildStep);
        }
        if (cloneConfig.postbuildStep != null) {
            this.postbuildStep = new String(cloneConfig.postbuildStep);
        }
        if (cloneConfig.preannouncebuildStep != null) {
            this.preannouncebuildStep = new String(cloneConfig.preannouncebuildStep);
        }
        if (cloneConfig.postannouncebuildStep != null) {
            this.postannouncebuildStep = new String(cloneConfig.postannouncebuildStep);
        }
        if (cloneConfig.parent != null) {
            subId = ManagedBuildManager.calculateChildId(cloneConfig.parent.getToolChain().getId(), null);
            subName = cloneConfig.parent.getToolChain().getName();
        } else {
            subId = ManagedBuildManager.calculateChildId(cloneConfig.getToolChain().getId(), null);
            subName = cloneConfig.getToolChain().getName();
        }
        if (cloneChildren) {
            this.toolChain = new ToolChain(this, subId, subName, (ToolChain)cloneConfig.getToolChain());
            BuildMacroProvider macroProvider = (BuildMacroProvider)ManagedBuildManager.getBuildMacroProvider();
            macroProvider.expandMacrosInBuildfile(this, macroProvider.areMacrosExpandedInBuildfile(cloneConfig));
            UserDefinedMacroSupplier userMacros = BuildMacroProvider.fUserDefinedMacroSupplier;
            userMacros.setMacros(userMacros.getMacros(3, cloneConfig), 3, this);
            UserDefinedEnvironmentSupplier userEnv = EnvironmentVariableProvider.fUserSupplier;
            userEnv.setVariables(userEnv.getVariables(cloneConfig), this);
        } else {
            ToolChain superChain = (ToolChain)cloneConfig.getToolChain();
            subId = ManagedBuildManager.calculateChildId(superChain.getId(), null);
            IToolChain newChain = this.createToolChain(superChain, subId, superChain.getName(), false);
            newChain.createOptions(superChain);
            ITool[] tools = superChain.getTools();
            int i = 0;
            while (i < tools.length) {
                Tool toolChild = (Tool)tools[i];
                subId = ManagedBuildManager.calculateChildId(toolChild.getId(), null);
                newChain.createTool(toolChild, subId, toolChild.getName(), false);
                ++i;
            }
        }
        if (cloneConfig.resourceConfigurationList != null) {
            List resElements = cloneConfig.getResourceConfigurationList();
            ListIterator iter = resElements.listIterator();
            while (iter.hasNext()) {
                ResourceConfiguration resConfig = (ResourceConfiguration)iter.next();
                subId = String.valueOf(this.getId()) + "." + ManagedBuildManager.getRandomNumber();
                ResourceConfiguration newResConfig = new ResourceConfiguration((IConfiguration)this, resConfig, subId);
                this.addResourceConfiguration(newResConfig);
            }
        }
        managedProject.addConfiguration(this);
        this.setDirty(true);
        this.rebuildNeeded = true;
    }

    protected void loadFromManifest(IManagedConfigElement element) {
        ManagedBuildManager.putConfigElement(this, element);
        this.setId(element.getAttribute("id"));
        this.name = element.getAttribute("name");
        this.description = element.getAttribute("description");
        String parentID = element.getAttribute("parent");
        if (parentID != null) {
            this.parent = ManagedBuildManager.getExtensionConfiguration(parentID);
        }
        this.artifactName = element.getAttribute("artifactName");
        this.errorParserIds = element.getAttribute("errorParsers");
        this.artifactExtension = element.getAttribute("artifactExtension");
        this.cleanCommand = element.getAttribute("cleanCommand");
        this.prebuildStep = element.getAttribute("prebuildStep");
        this.postbuildStep = element.getAttribute("postbuildStep");
        this.preannouncebuildStep = element.getAttribute("preannouncebuildStep");
        this.postannouncebuildStep = element.getAttribute("postannouncebuildStep");
    }

    protected void loadFromProject(Element element) {
        this.setId(element.getAttribute("id"));
        if (element.hasAttribute("name")) {
            this.setName(element.getAttribute("name"));
        }
        if (element.hasAttribute("description")) {
            this.description = element.getAttribute("description");
        }
        if (element.hasAttribute("parent")) {
            this.parent = this.managedProject.getConfiguration(element.getAttribute("parent"));
            if (this.parent == null) {
                this.parent = ManagedBuildManager.getExtensionConfiguration(element.getAttribute("parent"));
            }
        }
        if (element.hasAttribute("artifactName")) {
            this.artifactName = element.getAttribute("artifactName");
        }
        if (element.hasAttribute("errorParsers")) {
            this.errorParserIds = element.getAttribute("errorParsers");
        }
        if (element.hasAttribute("artifactExtension")) {
            this.artifactExtension = element.getAttribute("artifactExtension");
        }
        if (element.hasAttribute("cleanCommand")) {
            this.cleanCommand = element.getAttribute("cleanCommand");
        }
        if (element.hasAttribute("prebuildStep")) {
            this.prebuildStep = element.getAttribute("prebuildStep");
        }
        if (element.hasAttribute("postbuildStep")) {
            this.postbuildStep = element.getAttribute("postbuildStep");
        }
        if (element.hasAttribute("preannouncebuildStep")) {
            this.preannouncebuildStep = element.getAttribute("preannouncebuildStep");
        }
        if (element.hasAttribute("postannouncebuildStep")) {
            this.postannouncebuildStep = element.getAttribute("postannouncebuildStep");
        }
    }

    public void serialize(Document doc, Element element) {
        element.setAttribute("id", this.id);
        if (this.name != null) {
            element.setAttribute("name", this.name);
        }
        if (this.description != null) {
            element.setAttribute("description", this.description);
        }
        if (this.parent != null) {
            element.setAttribute("parent", this.parent.getId());
        }
        if (this.artifactName != null) {
            element.setAttribute("artifactName", this.artifactName);
        }
        if (this.errorParserIds != null) {
            element.setAttribute("errorParsers", this.errorParserIds);
        }
        if (this.artifactExtension != null) {
            element.setAttribute("artifactExtension", this.artifactExtension);
        }
        if (this.cleanCommand != null) {
            element.setAttribute("cleanCommand", this.cleanCommand);
        }
        if (this.prebuildStep != null) {
            element.setAttribute("prebuildStep", this.prebuildStep);
        }
        if (this.postbuildStep != null) {
            element.setAttribute("postbuildStep", this.postbuildStep);
        }
        if (this.preannouncebuildStep != null) {
            element.setAttribute("preannouncebuildStep", this.preannouncebuildStep);
        }
        if (this.postannouncebuildStep != null) {
            element.setAttribute("postannouncebuildStep", this.postannouncebuildStep);
        }
        Element toolChainElement = doc.createElement("toolChain");
        element.appendChild(toolChainElement);
        this.toolChain.serialize(doc, toolChainElement);
        List resElements = this.getResourceConfigurationList();
        ListIterator iter = resElements.listIterator();
        while (iter.hasNext()) {
            ResourceConfiguration resConfig = (ResourceConfiguration)iter.next();
            Element resElement = doc.createElement("resourceConfiguration");
            element.appendChild(resElement);
            resConfig.serialize(doc, resElement);
        }
        this.isDirty = false;
    }

    public IConfiguration getParent() {
        return this.parent;
    }

    public IResource getOwner() {
        if (this.managedProject != null) {
            return this.managedProject.getOwner();
        }
        return null;
    }

    public IProjectType getProjectType() {
        return this.projectType;
    }

    public IManagedProject getManagedProject() {
        return this.managedProject;
    }

    public IToolChain createToolChain(IToolChain superClass, String Id, String name, boolean isExtensionElement) {
        this.toolChain = new ToolChain(this, superClass, Id, name, isExtensionElement);
        this.setDirty(true);
        return this.toolChain;
    }

    public IToolChain getToolChain() {
        return this.toolChain;
    }

    public IResourceConfiguration[] getResourceConfigurations() {
        IResourceConfiguration[] resConfigs = new IResourceConfiguration[this.getResourceConfigurationList().size()];
        ListIterator iter = this.getResourceConfigurationList().listIterator();
        int i = 0;
        while (iter.hasNext()) {
            ResourceConfiguration resConfig = (ResourceConfiguration)iter.next();
            resConfigs[i++] = resConfig;
        }
        return resConfigs;
    }

    public IResourceConfiguration getResourceConfiguration(String resPath) {
        ResourceConfiguration resConfig = (ResourceConfiguration)this.getResourceConfigurationMap().get(resPath);
        return resConfig;
    }

    public ITool[] getFilteredTools() {
        if (this.toolChain == null) {
            return new ITool[0];
        }
        ITool[] localTools = this.toolChain.getTools();
        IManagedProject manProj = this.getManagedProject();
        if (manProj == null) {
            return localTools;
        }
        IProject project = (IProject)manProj.getOwner();
        Vector<ITool> tools = new Vector<ITool>(localTools.length);
        int i = 0;
        while (i < localTools.length) {
            ITool tool = localTools[i];
            try {
                switch (tool.getNatureFilter()) {
                    case 0: {
                        if (project.hasNature("org.eclipse.cdt.core.cnature") && !project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            tools.add(tool);
                        }
                        break;
                    }
                    case 1: {
                        if (project.hasNature("org.eclipse.cdt.core.ccnature")) {
                            tools.add(tool);
                        }
                        break;
                    }
                    case 2: {
                        tools.add(tool);
                        break;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return tools.toArray(new ITool[tools.size()]);
    }

    public ITool[] getTools() {
        return this.toolChain.getTools();
    }

    public ITool getTool(String id) {
        return this.toolChain.getTool(id);
    }

    public ITool getTargetTool() {
        String[] targetToolIds = this.toolChain.getTargetToolList();
        if (targetToolIds == null || targetToolIds.length == 0) {
            return null;
        }
        ITool[] tools = this.getFilteredTools();
        int i = 0;
        while (i < targetToolIds.length) {
            String targetToolId = targetToolIds[i];
            int j = 0;
            while (j < tools.length) {
                ITool targetTool;
                ITool tool = targetTool = tools[j];
                do {
                    if (!targetToolId.equals(tool.getId())) continue;
                    return targetTool;
                } while ((tool = tool.getSuperClass()) != null);
                ++j;
            }
            ++i;
        }
        return null;
    }

    public String getToolCommand(ITool tool) {
        return tool.getToolCommand();
    }

    public void setToolCommand(ITool tool, String command) {
        tool.setToolCommand(command);
    }

    public IOption setOption(IHoldsOptions holder, IOption option, boolean value) throws BuildException {
        IOption retOpt = option;
        if (option.getBooleanValue() != value) {
            if (option.isExtensionElement()) {
                IOption newSuperClass = option;
                if (((Option)option).wasOptRef()) {
                    newSuperClass = option.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.rebuildNeeded = true;
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String value) throws BuildException {
        IOption retOpt = option;
        String oldValue = option.getStringValue();
        if (oldValue != null && !oldValue.equals(value)) {
            if (option.isExtensionElement()) {
                IOption newSuperClass = option;
                if (((Option)option).wasOptRef()) {
                    newSuperClass = option.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.rebuildNeeded = true;
        }
        return retOpt;
    }

    public IOption setOption(IHoldsOptions holder, IOption option, String[] value) throws BuildException {
        Object[] oldValue;
        IOption retOpt = option;
        switch (option.getValueType()) {
            case 3: {
                oldValue = option.getStringListValue();
                break;
            }
            case 4: {
                oldValue = option.getIncludePaths();
                break;
            }
            case 5: {
                oldValue = option.getDefinedSymbols();
                break;
            }
            case 6: {
                oldValue = option.getLibraries();
                break;
            }
            case 7: {
                oldValue = option.getUserObjects();
                break;
            }
            default: {
                oldValue = new String[]{};
            }
        }
        if (!Arrays.equals(value, oldValue)) {
            if (option.isExtensionElement()) {
                IOption newSuperClass = option;
                if (((Option)option).wasOptRef()) {
                    newSuperClass = option.getSuperClass();
                }
                int nnn = ManagedBuildManager.getRandomNumber();
                String subId = String.valueOf(newSuperClass.getId()) + "." + nnn;
                retOpt = holder.createOption(newSuperClass, subId, null, false);
                retOpt.setValueType(option.getValueType());
                retOpt.setValue(value);
                this.setDirty(true);
            } else {
                option.setValue(value);
            }
            this.rebuildNeeded = true;
        }
        return retOpt;
    }

    private List getResourceConfigurationList() {
        if (this.resourceConfigurationList == null) {
            this.resourceConfigurationList = new ArrayList();
        }
        return this.resourceConfigurationList;
    }

    private Map getResourceConfigurationMap() {
        if (this.resourceConfigurationMap == null) {
            this.resourceConfigurationMap = new HashMap();
        }
        return this.resourceConfigurationMap;
    }

    public void addResourceConfiguration(ResourceConfiguration resConfig) {
        this.getResourceConfigurationList().add(resConfig);
        this.getResourceConfigurationMap().put(resConfig.getResourcePath(), resConfig);
        this.isDirty = true;
        this.rebuildNeeded = true;
    }

    public void removeResourceConfiguration(IResourceConfiguration resConfig) {
        this.getResourceConfigurationList().remove(resConfig);
        this.getResourceConfigurationMap().remove(resConfig.getResourcePath());
        this.isDirty = true;
        this.rebuildNeeded = true;
    }

    public String getName() {
        return this.name == null && this.parent != null ? this.parent.getName() : this.name;
    }

    public String getArtifactExtension() {
        if (this.artifactExtension == null) {
            if (this.parent != null) {
                return this.parent.getArtifactExtension();
            }
            return EMPTY_STRING;
        }
        return this.artifactExtension;
    }

    public String getArtifactName() {
        if (this.artifactName == null) {
            if (this.parent != null) {
                return this.parent.getArtifactName();
            }
            return EMPTY_STRING;
        }
        return this.artifactName;
    }

    public String getBuildArguments() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getArguments();
        }
        return new String("-k");
    }

    public String getBuildCommand() {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (builder != null) {
            return builder.getCommand();
        }
        return new String("make");
    }

    public String getPrebuildStep() {
        if (this.prebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPrebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.prebuildStep;
    }

    public String getPostbuildStep() {
        if (this.postbuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostbuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postbuildStep;
    }

    public String getPreannouncebuildStep() {
        if (this.preannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPreannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.preannouncebuildStep;
    }

    public String getPostannouncebuildStep() {
        if (this.postannouncebuildStep == null) {
            if (this.parent != null) {
                return this.parent.getPostannouncebuildStep();
            }
            return EMPTY_STRING;
        }
        return this.postannouncebuildStep;
    }

    public String getCleanCommand() {
        if (this.cleanCommand == null) {
            if (this.parent != null) {
                return this.parent.getCleanCommand();
            }
            if (Platform.getOS().equals("OS_WIN32")) {
                return new String("del");
            }
            return new String("rm");
        }
        return this.cleanCommand;
    }

    public String getDescription() {
        if (this.description == null) {
            if (this.parent != null) {
                return this.parent.getDescription();
            }
            return EMPTY_STRING;
        }
        return this.description;
    }

    public String getErrorParserIds() {
        if (this.errorParserIds != null) {
            return this.errorParserIds;
        }
        String errorParsers = null;
        if (this.parent != null) {
            errorParsers = this.parent.getErrorParserIds();
        }
        if (errorParsers == null && this.toolChain != null) {
            errorParsers = this.toolChain.getErrorParserIds(this);
        }
        return errorParsers;
    }

    public String[] getErrorParserList() {
        String[] errorParsers;
        String parserIDs = this.getErrorParserIds();
        if (parserIDs != null) {
            if (parserIDs.length() == 0) {
                errorParsers = new String[]{};
            } else {
                StringTokenizer tok = new StringTokenizer(parserIDs, ";");
                ArrayList<String> list = new ArrayList<String>(tok.countTokens());
                while (tok.hasMoreElements()) {
                    list.add(tok.nextToken());
                }
                String[] strArr = new String[]{""};
                errorParsers = list.toArray(strArr);
            }
        } else {
            errorParsers = CCorePlugin.getDefault().getAllErrorParsersIDs();
        }
        return errorParsers;
    }

    public void setArtifactExtension(String extension) {
        if (extension == null && this.artifactExtension == null) {
            return;
        }
        if (this.artifactExtension == null || extension == null || !this.artifactExtension.equals(extension)) {
            this.artifactExtension = extension;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public void setArtifactName(String name) {
        if (name == null && this.artifactName == null) {
            return;
        }
        if (this.artifactName == null || name == null || !this.artifactName.equals(name)) {
            this.artifactName = name;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public void setErrorParserIds(String ids) {
        String currentIds = this.getErrorParserIds();
        if (ids == null && currentIds == null) {
            return;
        }
        if (currentIds == null || ids == null || !currentIds.equals(ids)) {
            this.errorParserIds = ids;
            this.isDirty = true;
        }
    }

    public void setCleanCommand(String command) {
        if (command == null && this.cleanCommand == null) {
            return;
        }
        if (this.cleanCommand == null || command == null || !this.cleanCommand.equals(command)) {
            this.cleanCommand = command;
            this.isDirty = true;
        }
    }

    public void setDescription(String description) {
        if (description == null && this.description == null) {
            return;
        }
        if (this.description == null || description == null || !description.equals(this.description)) {
            this.description = description;
            this.isDirty = true;
        }
    }

    public void setBuildArguments(String makeArgs) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (makeArgs == null) {
            if (!builder.isExtensionElement()) {
                builder.setArguments(makeArgs);
                this.rebuildNeeded = true;
            }
        } else if (!makeArgs.equals(builder.getArguments())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.toolChain.createBuilder(builder, subId, builderName, false);
            }
            builder.setArguments(makeArgs);
            this.rebuildNeeded = true;
        }
    }

    public void setBuildCommand(String command) {
        IToolChain tc = this.getToolChain();
        IBuilder builder = tc.getBuilder();
        if (command == null) {
            if (!builder.isExtensionElement()) {
                builder.setCommand(command);
                this.rebuildNeeded = true;
            }
        } else if (!command.equals(builder.getCommand())) {
            if (builder.isExtensionElement()) {
                String subId = ManagedBuildManager.calculateChildId(builder.getId(), null);
                String builderName = String.valueOf(builder.getName()) + "." + this.getName();
                builder = this.toolChain.createBuilder(builder, subId, builderName, false);
            }
            builder.setCommand(command);
            this.rebuildNeeded = true;
        }
    }

    public void setPrebuildStep(String step) {
        if (step == null && this.prebuildStep == null) {
            return;
        }
        if (this.prebuildStep == null || step == null || !this.prebuildStep.equals(step)) {
            this.prebuildStep = step;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public void setPostbuildStep(String step) {
        if (step == null && this.postbuildStep == null) {
            return;
        }
        if (this.postbuildStep == null || step == null || !this.postbuildStep.equals(step)) {
            this.postbuildStep = step;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public void setPreannouncebuildStep(String announceStep) {
        if (announceStep == null && this.preannouncebuildStep == null) {
            return;
        }
        if (this.preannouncebuildStep == null || announceStep == null || !this.preannouncebuildStep.equals(announceStep)) {
            this.preannouncebuildStep = announceStep;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public void setPostannouncebuildStep(String announceStep) {
        if (announceStep == null && this.postannouncebuildStep == null) {
            return;
        }
        if (this.postannouncebuildStep == null || announceStep == null || !this.postannouncebuildStep.equals(announceStep)) {
            this.postannouncebuildStep = announceStep;
            this.rebuildNeeded = true;
            this.isDirty = true;
        }
    }

    public boolean isSupported() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.isSupported();
        }
        return false;
    }

    public boolean isExtensionElement() {
        return this.isExtensionConfig;
    }

    public boolean isDirty() {
        if (this.isExtensionConfig) {
            return false;
        }
        if (this.isDirty) {
            return true;
        }
        if (this.toolChain.isDirty()) {
            return true;
        }
        ListIterator iter = this.getResourceConfigurationList().listIterator();
        while (iter.hasNext()) {
            ResourceConfiguration current = (ResourceConfiguration)iter.next();
            if (!current.isDirty()) continue;
            return true;
        }
        return this.isDirty;
    }

    public boolean needsRebuild() {
        return this.rebuildNeeded;
    }

    public void setDirty(boolean isDirty) {
        this.isDirty = isDirty;
        if (!isDirty) {
            this.toolChain.setDirty(false);
            ListIterator iter = this.getResourceConfigurationList().listIterator();
            while (iter.hasNext()) {
                ResourceConfiguration current = (ResourceConfiguration)iter.next();
                current.setDirty(false);
            }
        }
    }

    public void setRebuildState(boolean rebuild) {
        this.rebuildNeeded = rebuild;
        if (rebuild && !this.isTemporary()) {
            ((EnvironmentVariableProvider)ManagedBuildManager.getEnvironmentVariableProvider()).checkBuildPathVariables(this);
        }
    }

    public boolean hasOverriddenBuildCommand() {
        IBuilder superB;
        IBuilder builder = this.getToolChain().getBuilder();
        if (builder != null && (superB = builder.getSuperClass()) != null) {
            String superA;
            String superC;
            String command = builder.getCommand();
            if (command != null && (superC = superB.getCommand()) != null && !command.equals(superC)) {
                return true;
            }
            String args = builder.getArguments();
            if (args != null && (superA = superB.getArguments()) != null && !args.equals(superA)) {
                return true;
            }
        }
        return false;
    }

    public void resolveReferences() {
        if (!this.resolved) {
            this.resolved = true;
            this.toolChain.resolveReferences();
            Iterator resConfigIter = this.getResourceConfigurationList().iterator();
            while (resConfigIter.hasNext()) {
                ResourceConfiguration current = (ResourceConfiguration)resConfigIter.next();
                current.resolveReferences();
            }
        }
    }

    public void reset() {
        IOption[] opts;
        ITool[] tools = this.getTools();
        IToolChain toolChain = this.getToolChain();
        ManagedBuildManager.performValueHandlerEvent(this, 2, false);
        int i = 0;
        while (i < tools.length) {
            ITool tool = tools[i];
            opts = tool.getOptions();
            int j = 0;
            while (j < opts.length) {
                tool.removeOption(opts[j]);
                ++j;
            }
            ++i;
        }
        opts = toolChain.getOptions();
        int j = 0;
        while (j < opts.length) {
            toolChain.removeOption(opts[j]);
            ++j;
        }
        this.rebuildNeeded = true;
    }

    public IResourceConfiguration createResourceConfiguration(IFile file) {
        String path = file.getFullPath().toString();
        String resourceName = file.getName();
        String id = String.valueOf(this.getId()) + "." + ManagedBuildManager.getRandomNumber();
        ResourceConfiguration resConfig = new ResourceConfiguration(this, id, resourceName, path);
        String extString = file.getFileExtension();
        ITool[] tools = this.getFilteredTools();
        String subId = new String();
        int i = 0;
        while (i < tools.length) {
            if (tools[i].buildsFileType(extString)) {
                subId = String.valueOf(tools[i].getId()) + "." + path;
                resConfig.createTool(tools[i], subId, tools[i].getName(), false);
            }
            ++i;
        }
        this.addResourceConfiguration(resConfig);
        ManagedBuildManager.performValueHandlerEvent(resConfig, 1);
        return resConfig;
    }

    public IConfigurationEnvironmentVariableSupplier getEnvironmentVariableSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getEnvironmentVariableSupplier();
        }
        return null;
    }

    public PluginVersionIdentifier getVersion() {
        if (this.version == null && this.toolChain != null) {
            return this.toolChain.getVersion();
        }
        return this.version;
    }

    public void setVersion(PluginVersionIdentifier version) {
    }

    public IConfigurationBuildMacroSupplier getBuildMacroSupplier() {
        IToolChain toolChain = this.getToolChain();
        if (toolChain != null) {
            return toolChain.getBuildMacroSupplier();
        }
        return null;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public void updateManagedBuildRevision(String revision) {
        super.updateManagedBuildRevision(revision);
        this.toolChain.updateManagedBuildRevision(revision);
        Iterator iter = this.getResourceConfigurationList().iterator();
        while (iter.hasNext()) {
            ((ResourceConfiguration)iter.next()).updateManagedBuildRevision(revision);
        }
    }
}

