/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinePage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchDialogAction
extends Action {
    private static final String PREFIX = "SearchDialogAction.";
    private static final String C_SEARCH_PAGE_ID = "org.eclipse.cdt.ui.CSearchPage";
    private ISelectionProvider fSelectionProvider;
    private ITextEditor fEditor;
    private IWorkbenchWindow fWorkbenchWindow;

    public SearchDialogAction(ISelectionProvider provider, CEditor editor) {
        super(CUIPlugin.getResourceString("SearchDialogAction.label"));
        this.setDescription(CUIPlugin.getResourceString("SearchDialogAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("SearchDialogAction.tooltip"));
        if (provider instanceof CContentOutlinePage) {
            this.setImageDescriptor(CPluginImages.DESC_OBJS_CSEARCH);
        }
        this.fSelectionProvider = provider;
        this.fEditor = editor;
    }

    public SearchDialogAction(ISelectionProvider provider, IWorkbenchWindow window) {
        super(CUIPlugin.getResourceString("SearchDialogAction.label"));
        this.setDescription(CUIPlugin.getResourceString("SearchDialogAction.description"));
        this.setToolTipText(CUIPlugin.getResourceString("SearchDialogAction.tooltip"));
        if (provider instanceof CContentOutlinePage) {
            this.setImageDescriptor(CPluginImages.DESC_OBJS_CSEARCH);
        }
        this.fSelectionProvider = provider;
        this.fWorkbenchWindow = window;
    }

    public void run() {
        ISelection selection = this.fSelectionProvider.getSelection();
        if (selection instanceof ITextSelection) {
            String search_name = ((ITextSelection)selection).getText();
            if (search_name.length() == 0) {
                return;
            }
        } else {
            ICElement element = SearchDialogAction.getElement(selection);
            if (element == null) {
                return;
            }
            String search_name = element.getElementName();
        }
        if (this.fEditor != null) {
            NewSearchUI.openSearchDialog((IWorkbenchWindow)this.fEditor.getEditorSite().getWorkbenchWindow(), (String)C_SEARCH_PAGE_ID);
        } else if (this.fWorkbenchWindow != null) {
            NewSearchUI.openSearchDialog((IWorkbenchWindow)this.fWorkbenchWindow, (String)C_SEARCH_PAGE_ID);
        }
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return SearchDialogAction.getElement(selection) != null;
    }

    public static String getEditorID(String name) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        if (registry != null) {
            IEditorDescriptor descriptor = registry.getDefaultEditor(name);
            if (descriptor != null) {
                return descriptor.getId();
            }
            return "org.eclipse.ui.systemExternalEditor";
        }
        return null;
    }
}

