/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.refactoring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.refactoring.Messages;
import org.eclipse.cdt.internal.refactoring.scanner.Scanner;
import org.eclipse.cdt.internal.refactoring.scanner.Token;
import org.eclipse.cdt.refactoring.CRefactoringMatch;
import org.eclipse.cdt.refactoring.ICRefactoringSearch;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.internal.core.SearchScope;
import org.eclipse.search.internal.core.text.ITextSearchResultCollector;
import org.eclipse.search.internal.core.text.MatchLocator;
import org.eclipse.search.internal.core.text.TextSearchEngine;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;

public class TextSearchWrapper
implements ICRefactoringSearch {
    static final Comparator COMPARE_FIRST_INTEGER = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((int[])o1)[0] - ((int[])o2)[0];
        }
    };

    private SearchScope createSearchScope(IFile file, int scope, String workingSetName, String[] patterns) {
        switch (scope) {
            case 2: {
                return this.defineSearchScope((IResource)file.getWorkspace().getRoot(), patterns);
            }
            case 4: {
                return this.defineSearchScope((IResource)file.getProject(), patterns);
            }
            case 1: {
                return this.defineSearchScope((IResource)file, patterns);
            }
            case 5: {
                SearchScope result = this.defineWorkingSetAsSearchScope(workingSetName, patterns);
                if (result == null) {
                    result = this.defineSearchScope((IResource)file.getWorkspace().getRoot(), patterns);
                }
                return result;
            }
        }
        return this.defineRelatedProjectsAsSearchScope(file.getProject(), patterns);
    }

    private SearchScope defineRelatedProjectsAsSearchScope(IProject project, String[] patterns) {
        HashSet<IProject> projects = new HashSet<IProject>();
        LinkedList<IProject> workThrough = new LinkedList<IProject>();
        workThrough.add(project);
        while (!workThrough.isEmpty()) {
            IProject prj = (IProject)workThrough.removeLast();
            if (!projects.add(prj)) continue;
            try {
                workThrough.addAll(Arrays.asList(prj.getReferencedProjects()));
                workThrough.addAll(Arrays.asList(prj.getReferencingProjects()));
            }
            catch (CoreException coreException) {}
        }
        IResource[] resources = projects.toArray(new IResource[projects.size()]);
        return this.defineSearchScope(resources, patterns);
    }

    private SearchScope defineWorkingSetAsSearchScope(String wsName, String[] patterns) {
        if (wsName == null) {
            return null;
        }
        IWorkingSetManager wsManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet ws = wsManager.getWorkingSet(wsName);
        if (ws == null) {
            return null;
        }
        SearchScope result = SearchScope.newSearchScope((String)"c/cpp", (IWorkingSet[])new IWorkingSet[]{ws});
        this.applyFilePatterns(result, patterns);
        return result;
    }

    private void applyFilePatterns(SearchScope scope, String[] patterns) {
        int i = 0;
        while (i < patterns.length) {
            String pattern = patterns[i];
            scope.addFileNamePattern(pattern);
            ++i;
        }
    }

    private SearchScope defineSearchScope(IResource resource, String[] patterns) {
        SearchScope result = SearchScope.newSearchScope((String)"c/cpp", (IResource[])new IResource[]{resource});
        this.applyFilePatterns(result, patterns);
        return result;
    }

    private SearchScope defineSearchScope(IResource[] resources, String[] patterns) {
        SearchScope result = SearchScope.newSearchScope((String)"c/cpp", (IResource[])resources);
        this.applyFilePatterns(result, patterns);
        return result;
    }

    public IStatus searchWord(int scope, IFile resource, String workingSet, String[] patterns, String word, IProgressMonitor monitor, List target) {
        int startPos = target.size();
        TextSearchEngine engine = new TextSearchEngine();
        StringBuffer searchPattern = new StringBuffer(word.length() + 8);
        searchPattern.append("\\b");
        searchPattern.append("\\Q");
        searchPattern.append(word);
        searchPattern.append("\\E");
        searchPattern.append("\\b");
        SearchScope searchscope = this.createSearchScope(resource, scope, workingSet, patterns);
        MatchLocator locator = new MatchLocator(searchPattern.toString(), true, true);
        SubProgressMonitor subProgress = new SubProgressMonitor(monitor, 95);
        ITextSearchResultCollector collector = new ITextSearchResultCollector((IProgressMonitor)subProgress, target){
            private final /* synthetic */ IProgressMonitor val$subProgress;
            private final /* synthetic */ List val$target;
            {
                this.val$subProgress = iProgressMonitor;
                this.val$target = list;
            }

            public IProgressMonitor getProgressMonitor() {
                return this.val$subProgress;
            }

            public void aboutToStart() {
            }

            public void accept(IResourceProxy proxy, String line, int start, int length, int lineNumber) {
                this.accept(proxy, start, length);
            }

            public void done() {
            }

            public void accept(IResourceProxy proxy, int start, int length) {
                IResource res = proxy.requestResource();
                if (res instanceof IFile) {
                    IFile file = (IFile)res;
                    ICElement elem = CoreModel.getDefault().create(file);
                    if (elem instanceof ITranslationUnit) {
                        this.val$target.add(new CRefactoringMatch(file, start, length, 0));
                    }
                }
            }
        };
        IStatus result = engine.search(searchscope, false, collector, locator);
        this.categorizeMatches(target.subList(startPos, target.size()), (IProgressMonitor)new SubProgressMonitor(monitor, 5));
        return result;
    }

    public void categorizeMatches(List matches, IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("TextSearch.monitor.categorizeMatches"), matches.size());
        IFile file = null;
        ArrayList locations = null;
        Iterator iter = matches.iterator();
        while (iter.hasNext()) {
            CRefactoringMatch match = (CRefactoringMatch)iter.next();
            IFile tfile = match.getFile();
            if (file == null || !file.equals((Object)tfile)) {
                file = tfile;
                locations = new ArrayList();
                this.computeLocations(file, locations);
            }
            match.setLocation(this.findLocation(match, locations));
            monitor.worked(1);
        }
    }

    private int findLocation(CRefactoringMatch match, ArrayList states) {
        int pos = Collections.binarySearch(states, new int[]{match.getOffset()}, COMPARE_FIRST_INTEGER);
        if (pos < 0 && (pos = -pos - 2) < 0) {
            pos = 0;
        }
        int endOffset = match.getOffset() + match.getLength();
        int location = 0;
        while (pos < states.size()) {
            int[] info = (int[])states.get(pos);
            if (info[0] >= endOffset) break;
            location |= info[1];
            ++pos;
        }
        return location;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void computeLocations(IFile file, ArrayList locations) {
        BufferedReader reader;
        Scanner scanner = new Scanner();
        try {
            reader = new BufferedReader(new InputStreamReader(file.getContents(), file.getCharset()));
        }
        catch (CoreException coreException) {
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return;
        }
        try {
            Token token;
            scanner.initialize(reader, null);
            scanner.setReuseToken(true);
            int lastState = 0;
            while ((token = scanner.nextToken()) != null) {
                int state = 128;
                switch (token.getType()) {
                    case 1001: 
                    case 1002: {
                        state = 2;
                        break;
                    }
                    case 129: 
                    case 131: 
                    case 132: {
                        state = 4;
                        break;
                    }
                    case 1003: {
                        state = 32;
                        break;
                    }
                    case 1005: {
                        state = 16;
                        break;
                    }
                    case 1004: {
                        state = 8;
                        break;
                    }
                }
                if (state == lastState) continue;
                locations.add(new int[]{token.getOffset(), state});
                lastState = state;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                ((Reader)reader).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        ((Reader)reader).close();
    }

    private int categorizePreprocessor(String text) {
        boolean skipHash = true;
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (!skipHash) break;
                skipHash = false;
                if (c != '#') break;
            }
            ++i;
        }
        String innerText = text.substring(i);
        if (innerText.startsWith("include")) {
            return 8;
        }
        if (innerText.startsWith("define") || innerText.startsWith("undef")) {
            return 16;
        }
        return 32;
    }
}

