/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.launch.internal.ui;

import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.launch.AbstractCLaunchDelegate;
import org.eclipse.cdt.launch.internal.ui.LaunchMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class LaunchUIPlugin
extends AbstractUIPlugin
implements IDebugEventSetListener {
    public static final String PLUGIN_ID = "org.eclipse.cdt.launch";
    private static LaunchUIPlugin fgPlugin;
    private static Shell debugDialogShell;

    public LaunchUIPlugin() {
        LaunchUIPlugin.setDefault(this);
    }

    private static void setDefault(LaunchUIPlugin plugin) {
        fgPlugin = plugin;
    }

    public static LaunchUIPlugin getDefault() {
        return fgPlugin;
    }

    public static Shell getShell() {
        if (LaunchUIPlugin.getActiveWorkbenchShell() != null) {
            return LaunchUIPlugin.getActiveWorkbenchShell();
        }
        if (debugDialogShell != null) {
            if (!debugDialogShell.isDisposed()) {
                return debugDialogShell;
            }
            debugDialogShell = null;
        }
        IWorkbenchWindow[] windows = LaunchUIPlugin.getDefault().getWorkbench().getWorkbenchWindows();
        return windows[0].getShell();
    }

    public static void setDialogShell(Shell shell) {
        debugDialogShell = shell;
    }

    public static String getUniqueIdentifier() {
        if (LaunchUIPlugin.getDefault() == null) {
            return PLUGIN_ID;
        }
        return LaunchUIPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        LaunchUIPlugin.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        LaunchUIPlugin.log((IStatus)new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return LaunchUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = LaunchUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void errorDialog(String message, IStatus status) {
        LaunchUIPlugin.log(status);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public static void errorDialog(String message, Throwable t) {
        LaunchUIPlugin.log(t);
        Shell shell = LaunchUIPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            Status status = new Status(4, LaunchUIPlugin.getUniqueIdentifier(), 1, t.getMessage(), null);
            ErrorDialog.openError((Shell)shell, (String)LaunchMessages.getString("LaunchUIPlugin.Error"), (String)message, (IStatus)status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        super.stop(context);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            Object o;
            if (events[i].getKind() == 8 && (o = events[i].getSource()) instanceof IProcess) {
                IProcess proc = (IProcess)o;
                ICProject cproject = null;
                try {
                    cproject = AbstractCLaunchDelegate.getCProject(proc.getLaunch().getLaunchConfiguration());
                }
                catch (CoreException coreException) {}
                if (cproject != null) {
                    try {
                        cproject.getProject().refreshLocal(2, null);
                    }
                    catch (CoreException coreException) {}
                }
            }
            ++i;
        }
    }
}

