/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.ctagsindexer;

import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.internal.core.index.cindexstorage.IndexedFileEntry;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagEntry;
import org.eclipse.cdt.internal.core.index.ctagsindexer.CTagsIndexerRunner;

public class CTagsConsoleParser
implements IConsoleParser {
    static final String TAB_SEPARATOR = "\t";
    static final String PATTERN_SEPARATOR = ";\"";
    static final String COLONCOLON = "::";
    static final String LANGUAGE = "language";
    static final String KIND = "kind";
    static final String LINE = "line";
    static final String FILE = "file";
    static final String INHERITS = "inherits";
    static final String ACCESS = "access";
    static final String IMPLEMENTATION = "implementation";
    static final String SIGNATURE = "signature";
    static final String CLASS = "class";
    static final String MACRO = "macro";
    static final String ENUMERATOR = "enumerator";
    static final String FUNCTION = "function";
    static final String ENUM = "enum";
    static final String MEMBER = "member";
    static final String NAMESPACE = "namespace";
    static final String PROTOTYPE = "prototype";
    static final String STRUCT = "struct";
    static final String TYPEDEF = "typedef";
    static final String UNION = "union";
    static final String VARIABLE = "variable";
    static final String EXTERNALVAR = "externvar";
    private CTagsIndexerRunner indexer;

    public CTagsConsoleParser(CTagsIndexerRunner indexer) {
        this.indexer = indexer;
    }

    public boolean processLine(String line) {
        CTagEntry tempTag = new CTagEntry(this, line);
        if (this.indexer != null) {
            tempTag.addTagToIndexOutput(this.getFileNumber(), this.indexer.getOutput());
        }
        return false;
    }

    public CTagEntry processLineReturnTag(String line) {
        CTagEntry tempTag = new CTagEntry(this, line);
        return tempTag;
    }

    private int getFileNumber() {
        int fileNum = 0;
        IndexedFileEntry mainIndexFile = this.indexer.getOutput().getIndexedFile(this.indexer.getResourceFile().getFullPath().toString());
        if (mainIndexFile != null) {
            fileNum = mainIndexFile.getFileID();
        }
        return fileNum;
    }

    public void shutdown() {
    }
}

