/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.pst;

import org.eclipse.cdt.internal.core.parser.pst.BasicTypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.IDeferredTemplateInstance;
import org.eclipse.cdt.internal.core.parser.pst.IParameterizedSymbol;
import org.eclipse.cdt.internal.core.parser.pst.ISymbol;
import org.eclipse.cdt.internal.core.parser.pst.ITypeInfo;
import org.eclipse.cdt.internal.core.parser.pst.TemplateEngine;

public class TypeInfo
extends BasicTypeInfo
implements ITypeInfo {
    private ISymbol _typeDeclaration = null;
    private boolean _hasDefaultValue = false;

    public ISymbol getTypeSymbol() {
        return this._typeDeclaration;
    }

    public void setTypeSymbol(ISymbol type) {
        this._typeDeclaration = type;
    }

    public boolean getHasDefault() {
        return this._hasDefaultValue;
    }

    public void setHasDefault(boolean def) {
        this._hasDefaultValue = def;
    }

    public void clear() {
        super.clear();
        this._typeDeclaration = null;
        this._hasDefaultValue = false;
    }

    public void copy(ITypeInfo t) {
        super.copy(t);
        this._typeDeclaration = t.getTypeSymbol();
        this._hasDefaultValue = t.getHasDefault();
    }

    public boolean equals(Object t) {
        if (!super.equals(t)) {
            return false;
        }
        ITypeInfo type = (ITypeInfo)t;
        boolean result = true;
        ISymbol symbol = type.getTypeSymbol();
        if (this._typeDeclaration != null && symbol != null) {
            if (this._typeDeclaration.isType(ITypeInfo.t__Bool, ITypeInfo.t_void) && symbol.isType(ITypeInfo.t__Bool, ITypeInfo.t_void)) {
                result &= this._typeDeclaration.getType() == symbol.getType();
            } else if (this._typeDeclaration.isType(ITypeInfo.t_function) && symbol.isType(ITypeInfo.t_function)) {
                IParameterizedSymbol f1 = (IParameterizedSymbol)this._typeDeclaration;
                IParameterizedSymbol f2 = (IParameterizedSymbol)symbol;
                result &= f1.hasSameParameters(f2);
                result = f1.getReturnType() != null && f2.getReturnType() != null ? (result &= f1.getReturnType().getTypeInfo().equals(f2.getReturnType().getTypeInfo())) : (result &= f1.getReturnType() == f2.getReturnType());
            } else {
                result = this._typeDeclaration.isType(ITypeInfo.t_templateParameter) && symbol.isType(ITypeInfo.t_templateParameter) ? (result &= TemplateEngine.templateParametersAreEquivalent(this._typeDeclaration, symbol)) : (this._typeDeclaration instanceof IDeferredTemplateInstance && symbol instanceof IDeferredTemplateInstance ? (result &= TemplateEngine.deferedInstancesAreEquivalent((IDeferredTemplateInstance)this._typeDeclaration, (IDeferredTemplateInstance)symbol)) : (result &= this._typeDeclaration == symbol));
            }
        } else {
            result &= this._typeDeclaration == symbol;
        }
        return result;
    }
}

