/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDragAdapter;
import org.eclipse.cdt.internal.ui.cview.SelectionTransferDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.CDTViewerDragAdapter;
import org.eclipse.cdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.cdt.internal.ui.dnd.TransferDragSourceListener;
import org.eclipse.cdt.internal.ui.dnd.TransferDropTargetListener;
import org.eclipse.cdt.internal.ui.editor.CContentOutlinerProvider;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.LexicalSortingAction;
import org.eclipse.cdt.internal.ui.editor.OpenIncludeAction;
import org.eclipse.cdt.internal.ui.editor.TogglePresentationAction;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.ProblemTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.StandardCElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.cdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.cdt.ui.actions.MemberFilterActionGroup;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.actions.RefactoringActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class CContentOutlinePage
extends Page
implements IContentOutlinePage,
ISelectionChangedListener {
    private CEditor fEditor;
    private ITranslationUnit fInput;
    private ProblemTreeViewer fTreeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();
    private TogglePresentationAction fTogglePresentation;
    private String fContextMenuId;
    private Menu fMenu;
    protected OpenIncludeAction fOpenIncludeAction;
    private IncludeGroupingAction fIncludeGroupingAction;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ActionGroup fSelectionSearchGroup;
    private ActionGroup fRefactoringActionGroup;
    private ActionGroup fOpenViewActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;

    public CContentOutlinePage(CEditor editor) {
        this("#TranslationUnitOutlinerContext", editor);
    }

    public CContentOutlinePage(String contextMenuID, CEditor editor) {
        this.fEditor = editor;
        this.fInput = null;
        this.fContextMenuId = contextMenuID;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fOpenIncludeAction = new OpenIncludeAction((ISelectionProvider)this);
    }

    public ICElement getRoot() {
        return this.fInput;
    }

    public CEditor getEditor() {
        return this.fEditor;
    }

    public void contentUpdated() {
        TreeViewer treeViewer;
        if (this.fInput != null && (treeViewer = this.getTreeViewer()) != null && !treeViewer.getControl().isDisposed()) {
            treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!treeViewer.getControl().isDisposed()) {
                        ISelection sel = treeViewer.getSelection();
                        treeViewer.setSelection(CContentOutlinePage.this.updateSelection(sel));
                        treeViewer.refresh();
                    }
                }
            });
        }
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList newSelection = new ArrayList();
        if (sel instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof ICElement)) continue;
                newSelection.add(o);
            }
        }
        return new StructuredSelection(newSelection);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        CUIPlugin.createStandardGroups(menu);
        if (OpenViewActionGroup.canActionBeAdded(this.getSelection())) {
            this.fOpenViewActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
            this.fOpenViewActionGroup.fillContextMenu(menu);
            this.fOpenViewActionGroup.setContext(null);
            menu.add((IContributionItem)new Separator("additions"));
        }
        if (OpenIncludeAction.canActionBeAdded(this.getSelection())) {
            menu.add((IAction)this.fOpenIncludeAction);
        }
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
        if (SelectionSearchGroup.canActionBeAdded(this.getSelection())) {
            this.fSelectionSearchGroup.fillContextMenu(menu);
            menu.add((IContributionItem)new Separator("additions"));
        }
        this.fRefactoringActionGroup.fillContextMenu(menu);
    }

    protected CContentOutlinerProvider createContentProvider(TreeViewer viewer) {
        return new CContentOutlinerProvider(viewer, CUIPlugin.getActiveWorkbenchWindow().getActivePage().getActivePart().getSite());
    }

    protected ProblemTreeViewer createTreeViewer(Composite parent) {
        this.fTreeViewer = new ProblemTreeViewer(parent, 770);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createContentProvider(this.fTreeViewer));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(new StandardCElementLabelProvider(), true));
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.addSelectionChangedListener(this);
        return this.fTreeViewer;
    }

    public void createControl(Composite parent) {
        this.fTreeViewer = this.createTreeViewer(parent);
        this.initDragAndDrop();
        MenuManager manager = new MenuManager(this.fContextMenuId);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CContentOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        Control control = this.fTreeViewer.getControl();
        this.fMenu = manager.createContextMenu(control);
        control.setMenu(this.fMenu);
        this.fTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (CContentOutlinePage.this.fOpenIncludeAction != null) {
                    CContentOutlinePage.this.fOpenIncludeAction.run();
                }
            }
        });
        IPageSite site = this.getSite();
        site.registerContextMenu(this.fContextMenuId, manager, (ISelectionProvider)this.fTreeViewer);
        site.setSelectionProvider((ISelectionProvider)this.fTreeViewer);
        IActionBars bars = site.getActionBars();
        bars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        this.fSelectionSearchGroup = new SelectionSearchGroup(this);
        this.fRefactoringActionGroup = new RefactoringActionGroup(this, null);
        this.fOpenViewActionGroup = new OpenViewActionGroup(this);
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.eclipse.cdt.ui.COutlinePage", (StructuredViewer)this.getTreeViewer());
        this.registerActionBars(bars);
        this.fTreeViewer.setInput(this.fInput);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.cdt.ui.outline_view");
    }

    public void dispose() {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.removeSelectionChangedListener(this);
        }
        if (this.fTogglePresentation != null) {
            this.fTogglePresentation.setEditor(null);
            this.fTogglePresentation = null;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fOpenViewActionGroup != null) {
            this.fOpenViewActionGroup.dispose();
            this.fOpenViewActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        if (this.selectionChangedListeners != null) {
            this.selectionChangedListeners.clear();
            this.selectionChangedListeners = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        this.fInput = null;
        super.dispose();
    }

    private void registerActionBars(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        LexicalSortingAction action = new LexicalSortingAction(this.getTreeViewer());
        toolBarManager.add((IAction)action);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fTreeViewer, "COutlineViewer");
        this.fMemberFilterActionGroup.fillActionBars(actionBars);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fIncludeGroupingAction = new IncludeGroupingAction(this);
        menu.add((IAction)this.fIncludeGroupingAction);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((ISelectionChangedListener)listeners[i]).selectionChanged(event);
            ++i;
        }
    }

    public Control getControl() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return this.fTreeViewer.getControl();
    }

    public ISelection getSelection() {
        if (this.fTreeViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fTreeViewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    public void setFocus() {
        this.fTreeViewer.getControl().setFocus();
    }

    public void setSelection(ISelection selection) {
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setSelection(selection);
        }
    }

    public void setInput(ITranslationUnit unit) {
        this.fInput = unit;
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(this.fInput);
        }
    }

    private void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fTreeViewer)};
        this.fTreeViewer.addDropSupport(ops | 0x10, transfers, new DelegatingDropAdapter(dropListeners));
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fTreeViewer)};
        this.fTreeViewer.addDragSupport(ops, transfers, new CDTViewerDragAdapter((StructuredViewer)this.fTreeViewer, dragListeners));
    }

    public class IncludeGroupingAction
    extends Action {
        CContentOutlinePage outLine;

        public IncludeGroupingAction(CContentOutlinePage outlinePage) {
            super(ActionMessages.getString("IncludesGroupingAction.label"));
            this.setDescription(ActionMessages.getString("IncludesGroupingAction.description"));
            this.setToolTipText(ActionMessages.getString("IncludeGroupingAction.tooltip"));
            CPluginImages.setImageDescriptors((IAction)this, "lcl16/", "synced.gif");
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.cdt.ui.link_editor_action");
            boolean enabled = this.isIncludesGroupingEnabled();
            this.setChecked(enabled);
            this.outLine = outlinePage;
        }

        public void run() {
            boolean oldValue = this.isIncludesGroupingEnabled();
            PreferenceConstants.getPreferenceStore().setValue("org.eclipse.cdt.ui.outline.groupincludes", this.isChecked());
            if (oldValue != this.isChecked()) {
                this.outLine.contentUpdated();
            }
        }

        public boolean isIncludesGroupingEnabled() {
            return PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupincludes");
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        CContentOutlinePage fOutlinePage;

        public ToggleLinkingAction(CContentOutlinePage outlinePage) {
            boolean isLinkingEnabled = true;
            this.setChecked(isLinkingEnabled);
            this.fOutlinePage = outlinePage;
        }

        public void run() {
        }
    }
}

