/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.wizards.OpenNewWizardAction;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;

public class CWizardRegistry {
    private static final String TAG_WIZARD = "wizard";
    private static final String ATT_CATEGORY = "category";
    private static final String ATT_PROJECT = "project";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    private static final String ATT_CTYPE = "ctype";
    private static final String ATT_CFILE = "cfile";
    private static final String ATT_CFOLDER = "cfolder";
    private static final String ATT_CPROJECT = "cproject";
    private static final String ATT_CCPROJECT = "ccproject";
    private static final String TAG_CLASS = "class";
    private static final String TAG_ID = "id";
    private static final String PL_NEW = "newWizards";

    public static boolean isCProjectWizard(IConfigurationElement element) {
        String category = element.getAttribute(ATT_CATEGORY);
        return category != null && category.equals("org.eclipse.cdt.ui.newCWizards");
    }

    public static boolean isCCProjectWizard(IConfigurationElement element) {
        String category = element.getAttribute(ATT_CATEGORY);
        return category != null && category.equals("org.eclipse.cdt.ui.newCCWizards");
    }

    public static String[] getProjectWizardIDs() {
        return CWizardRegistry.getWizardIDs(CWizardRegistry.getProjectWizardElements());
    }

    public static IConfigurationElement[] getProjectWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = CWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CWizardRegistry.isProjectWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isProjectWizard(IConfigurationElement element) {
        String project = element.getAttribute(ATT_PROJECT);
        if (project != null) {
            return Boolean.valueOf(project);
        }
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && (name.equals(ATT_CPROJECT) || name.equals(ATT_CCPROJECT)) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public static IAction[] getProjectWizardActions() {
        return CWizardRegistry.createActions(CWizardRegistry.getProjectWizardElements());
    }

    public static String[] getTypeWizardIDs() {
        return CWizardRegistry.getWizardIDs(CWizardRegistry.getTypeWizardElements());
    }

    public static IConfigurationElement[] getTypeWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = CWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CWizardRegistry.isTypeWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isTypeWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_CTYPE) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getTypeWizardActions() {
        return CWizardRegistry.createActions(CWizardRegistry.getTypeWizardElements());
    }

    public static String[] getFileWizardIDs() {
        return CWizardRegistry.getWizardIDs(CWizardRegistry.getFileWizardElements());
    }

    public static IConfigurationElement[] getFileWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = CWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CWizardRegistry.isFileWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isFileWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_CFILE) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getFolderWizardActions() {
        return CWizardRegistry.createActions(CWizardRegistry.getFolderWizardElements());
    }

    public static String[] getFolderWizardIDs() {
        return CWizardRegistry.getWizardIDs(CWizardRegistry.getFolderWizardElements());
    }

    public static IConfigurationElement[] getFolderWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = CWizardRegistry.getAllWizardElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (CWizardRegistry.isFolderWizard(element)) {
                elemList.add(element);
            }
            ++i;
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }

    private static boolean isFolderWizard(IConfigurationElement element) {
        IConfigurationElement[] classElements = element.getChildren(TAG_CLASS);
        if (classElements.length > 0) {
            int i = 0;
            while (i < classElements.length) {
                IConfigurationElement[] paramElements = classElements[i].getChildren(TAG_PARAMETER);
                int k = 0;
                while (k < paramElements.length) {
                    String value;
                    IConfigurationElement curr = paramElements[k];
                    String name = curr.getAttribute(TAG_NAME);
                    if (name != null && name.equals(ATT_CFOLDER) && (value = curr.getAttribute(TAG_VALUE)) != null) {
                        return Boolean.valueOf(value);
                    }
                    ++k;
                }
                ++i;
            }
        }
        return false;
    }

    public static IAction[] getFileWizardActions() {
        return CWizardRegistry.createActions(CWizardRegistry.getFileWizardElements());
    }

    private static String[] getWizardIDs(IConfigurationElement[] elements) {
        String id;
        IConfigurationElement element;
        ArrayList<String> idList = new ArrayList<String>();
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CWizardRegistry.isCProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CWizardRegistry.isCCProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
            }
            ++i;
        }
        return idList.toArray(new String[idList.size()]);
    }

    private static IAction[] createActions(IConfigurationElement[] elements) {
        OpenNewWizardAction action;
        String id;
        IConfigurationElement element;
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<OpenNewWizardAction> actionList = new ArrayList<OpenNewWizardAction>();
        int i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CWizardRegistry.isCProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
                action = new OpenNewWizardAction(element);
                if (action != null) {
                    actionList.add(action);
                }
            }
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            element = elements[i];
            if (CWizardRegistry.isCCProjectWizard(element) && (id = element.getAttribute(TAG_ID)) != null && !idList.contains(id)) {
                idList.add(id);
                action = new OpenNewWizardAction(element);
                if (action != null) {
                    actionList.add(action);
                }
            }
            ++i;
        }
        return actionList.toArray(new IAction[actionList.size()]);
    }

    public static IConfigurationElement[] getAllWizardElements() {
        ArrayList<IConfigurationElement> elemList = new ArrayList<IConfigurationElement>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", PL_NEW);
        if (extensionPoint != null) {
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String category;
                IConfigurationElement element = elements[i];
                if (element.getName().equals(TAG_WIZARD) && (category = element.getAttribute(ATT_CATEGORY)) != null && (category.equals("org.eclipse.cdt.ui.newCCWizards") || category.equals("org.eclipse.cdt.ui.newCWizards"))) {
                    elemList.add(element);
                }
                ++i;
            }
        }
        return elemList.toArray(new IConfigurationElement[elemList.size()]);
    }
}

