/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import java.util.List;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.Page;

public class OpenViewActionGroup
extends ActionGroup {
    private boolean fEditorIsOwner;
    private IWorkbenchSite fSite;
    private PropertyDialogAction fOpenPropertiesDialog;

    public OpenViewActionGroup(Page page) {
        this.createSiteActions((IWorkbenchSite)page.getSite());
    }

    public OpenViewActionGroup(IViewPart part) {
        this.createSiteActions((IWorkbenchSite)part.getSite());
    }

    public OpenViewActionGroup(CEditor part) {
        this.fEditorIsOwner = true;
        this.initialize((IWorkbenchSite)part.getEditorSite());
    }

    private void createSiteActions(IWorkbenchSite site) {
        this.fOpenPropertiesDialog = new PropertyDialogAction((IShellProvider)site, site.getSelectionProvider());
        this.fOpenPropertiesDialog.setActionDefinitionId("org.eclipse.ui.file.properties");
        this.initialize(site);
    }

    private void initialize(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        if (!this.fEditorIsOwner) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection ss = (IStructuredSelection)selection;
                this.fOpenPropertiesDialog.selectionChanged(ss);
            } else {
                this.fOpenPropertiesDialog.selectionChanged(selection);
            }
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        IStructuredSelection selection = this.getStructuredSelection();
        if (this.fOpenPropertiesDialog != null && this.fOpenPropertiesDialog.isEnabled() && selection != null && this.fOpenPropertiesDialog.isApplicableForSelection(selection)) {
            menu.appendToGroup("group.properties", (IAction)this.fOpenPropertiesDialog);
        }
    }

    public void dispose() {
        this.fSite.getSelectionProvider();
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fOpenPropertiesDialog);
    }

    private void appendToGroup(IMenuManager menu, IAction action) {
        if (action.isEnabled()) {
            menu.appendToGroup("group.open", action);
        }
    }

    private IStructuredSelection getStructuredSelection() {
        ISelection selection = this.getContext().getSelection();
        if (selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static boolean canActionBeAdded(ISelection selection) {
        if (selection instanceof ITextSelection) {
            return ((ITextSelection)selection).getLength() > 0;
        }
        return OpenViewActionGroup.getElement(selection) != null;
    }

    private static ICElement getElement(ISelection sel) {
        Object element;
        List list;
        if (!sel.isEmpty() && sel instanceof IStructuredSelection && (list = ((IStructuredSelection)sel).toList()).size() == 1 && (element = list.get(0)) instanceof ICElement) {
            return (ICElement)element;
        }
        return null;
    }
}

