/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import org.eclipse.cdt.internal.corext.refactoring.base.Change;
import org.eclipse.cdt.internal.corext.refactoring.base.ChangeContext;
import org.eclipse.cdt.internal.corext.refactoring.base.IChange;
import org.eclipse.cdt.internal.corext.refactoring.base.ICompositeChange;
import org.eclipse.cdt.internal.corext.refactoring.changes.TextChange;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementContentProvider;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementLabelProvider;
import org.eclipse.cdt.internal.ui.refactoring.ChangeElementTreeViewer;
import org.eclipse.cdt.internal.ui.refactoring.DefaultChangeElement;
import org.eclipse.cdt.internal.ui.refactoring.IChangePreviewViewer;
import org.eclipse.cdt.internal.ui.refactoring.IPreviewWizardPage;
import org.eclipse.cdt.internal.ui.refactoring.PerformChangeOperation;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.cdt.internal.ui.refactoring.RefactoringWizardPage;
import org.eclipse.cdt.internal.ui.util.ViewerPane;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;

public class PreviewWizardPage
extends RefactoringWizardPage
implements IPreviewWizardPage {
    private IChange fChange;
    private ChangeElement fCurrentSelection;
    private PageBook fPageContainer;
    private Control fStandardPage;
    private Control fNullPage;
    private ChangeElementTreeViewer fTreeViewer;

    public PreviewWizardPage() {
        super("PreviewPage");
        this.setDescription(RefactoringMessages.getString("PreviewWizardPage.description"));
    }

    public void setChange(IChange change) {
        if (this.fChange == change) {
            return;
        }
        this.fChange = change;
        this.setTreeViewerInput();
    }

    protected ChangeElementTreeViewer createTreeViewer(Composite parent) {
        return new ChangeElementTreeViewer(parent);
    }

    protected ITreeContentProvider createTreeContentProvider() {
        return new ChangeElementContentProvider();
    }

    protected ILabelProvider createTreeLabelProvider() {
        return new ChangeElementLabelProvider(CElementLabelProvider.SHOW_DEFAULT | 0x100);
    }

    protected boolean performFinish() {
        return this.getRefactoringWizard().performFinish(new PerformChangeOperation(this.fChange));
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.fPageContainer = new PageBook(parent, 0);
        this.fStandardPage = this.createStandardPreviewPage((Composite)this.fPageContainer);
        this.fNullPage = this.createNullPage((Composite)this.fPageContainer);
        this.setControl((Control)this.fPageContainer);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.cdt.ui.refactoring_preview_wizard_page_context");
    }

    private Composite createStandardPreviewPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        SashForm sashForm = new SashForm(result, 256);
        ViewerPane pane = new ViewerPane((Composite)sashForm, 0x800800);
        pane.setText(RefactoringMessages.getString("PreviewWizardPage.changes"));
        ToolBarManager tbm = pane.getToolBarManager();
        tbm.add((IAction)new NextChange());
        tbm.add((IAction)new PreviousChange());
        tbm.update(true);
        this.fTreeViewer = this.createTreeViewer((Composite)pane);
        this.fTreeViewer.setContentProvider((IContentProvider)this.createTreeContentProvider());
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.createTreeLabelProvider());
        this.fTreeViewer.addSelectionChangedListener(this.createSelectionChangedListener());
        this.fTreeViewer.addCheckStateListener(this.createCheckStateListener());
        pane.setContent(this.fTreeViewer.getControl());
        this.setTreeViewerInput();
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        sashForm.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createNullPage(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0x1000000);
        label.setText(RefactoringMessages.getString("PreviewWizardPage.no_source_code_change"));
        label.setLayoutData((Object)new GridData(768));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void setVisible(boolean visible) {
        this.fCurrentSelection = null;
        if (this.hasChanges()) {
            ITreeContentProvider provider;
            Object[] elements;
            IStructuredSelection selection;
            this.fPageContainer.showPage(this.fStandardPage);
            ChangeElement treeViewerInput = (ChangeElement)this.fTreeViewer.getInput();
            if (visible && treeViewerInput != null && (selection = (IStructuredSelection)this.fTreeViewer.getSelection()).isEmpty() && (elements = (provider = (ITreeContentProvider)this.fTreeViewer.getContentProvider()).getElements((Object)treeViewerInput)) != null && elements.length > 0) {
                Object[] subElements;
                Object element = elements[0];
                if (this.getRefactoringWizard().getExpandFirstNode() && (subElements = provider.getElements(element)) != null && subElements.length > 0) {
                    this.fTreeViewer.expandToLevel(element, 999);
                }
                this.fTreeViewer.setSelection((ISelection)new StructuredSelection(element));
            }
            super.setVisible(visible);
            this.fTreeViewer.getControl().setFocus();
        } else {
            this.fPageContainer.showPage(this.fNullPage);
            super.setVisible(visible);
        }
        this.getRefactoringWizard().setPreviewShown(visible);
    }

    private void setTreeViewerInput() {
        IChange change = this.computeChangeInput();
        DefaultChangeElement input = change == null ? null : (change instanceof ICompositeChange && !(change instanceof TextChange) ? new DefaultChangeElement(null, change) : new DefaultChangeElement(null, new DummyRootNode(change)));
        if (this.fTreeViewer != null) {
            this.fTreeViewer.setInput(input);
        }
    }

    private IChange computeChangeInput() {
        IChange result = this.fChange;
        if (result == null) {
            return result;
        }
        while (result instanceof ICompositeChange) {
            IChange[] children = ((ICompositeChange)result).getChildren();
            if (children.length == 1) {
                result = children[0];
                continue;
            }
            return result;
        }
        return result;
    }

    private ICheckStateListener createCheckStateListener() {
        return new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ChangeElement element = (ChangeElement)event.getElement();
                if (this.isChild(PreviewWizardPage.this.fCurrentSelection, element) || this.isChild(element, PreviewWizardPage.this.fCurrentSelection)) {
                    PreviewWizardPage.this.showPreview(PreviewWizardPage.this.fCurrentSelection);
                }
            }

            private boolean isChild(ChangeElement element, ChangeElement child) {
                while (child != null) {
                    if (child == element) {
                        return true;
                    }
                    child = child.getParent();
                }
                return false;
            }
        };
    }

    private ISelectionChangedListener createSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.size() == 1) {
                    ChangeElement newSelection = (ChangeElement)sel.getFirstElement();
                    if (newSelection != PreviewWizardPage.this.fCurrentSelection) {
                        PreviewWizardPage.this.fCurrentSelection = newSelection;
                        PreviewWizardPage.this.showPreview(newSelection);
                    }
                } else {
                    PreviewWizardPage.this.showPreview(null);
                }
            }
        };
    }

    private void showPreview(ChangeElement element) {
        this.showNullPreviewer();
    }

    private void showNullPreviewer() {
    }

    public boolean hasChanges() {
        if (this.fChange == null) {
            return false;
        }
        if (this.fChange instanceof ICompositeChange) {
            return ((ICompositeChange)this.fChange).getChildren().length > 0;
        }
        return true;
    }

    private static class DummyRootNode
    extends Change
    implements ICompositeChange {
        private IChange[] fChildren;

        public DummyRootNode(IChange change) {
            this.fChildren = new IChange[]{change};
        }

        public IChange[] getChildren() {
            return this.fChildren;
        }

        public String getName() {
            return null;
        }

        public Object getModifiedLanguageElement() {
            return null;
        }

        public IChange getUndoChange() {
            return null;
        }

        public void perform(ChangeContext context, IProgressMonitor pm) {
        }
    }

    private static class NullPreviewer
    implements IChangePreviewViewer {
        private Label fLabel;

        NullPreviewer() {
        }

        public void createControl(Composite parent) {
            this.fLabel = new Label(parent, 0x1800000);
            this.fLabel.setText(RefactoringMessages.getString("PreviewWizardPage.no_preview"));
        }

        public void refresh() {
        }

        public Control getControl() {
            return this.fLabel;
        }

        public void setInput(Object input) throws CoreException {
        }
    }

    private class NextChange
    extends Action {
        public NextChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_NEXT);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_NEXT);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_NEXT);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.next_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.next_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealNext();
        }
    }

    private class PreviousChange
    extends Action {
        public PreviousChange() {
            this.setImageDescriptor(CompareUI.DESC_ETOOL_PREV);
            this.setDisabledImageDescriptor(CompareUI.DESC_DTOOL_PREV);
            this.setHoverImageDescriptor(CompareUI.DESC_CTOOL_PREV);
            this.setToolTipText(RefactoringMessages.getString("PreviewWizardPage.previous_Change"));
            WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.previous_change_action");
        }

        public void run() {
            PreviewWizardPage.this.fTreeViewer.revealPrevious();
        }
    }
}

