/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.CHelpProviderManager;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICHelpResourceDescriptor;
import org.eclipse.cdt.ui.text.ICHelpInvocationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class CHelpDisplayContext
implements IContext {
    private IHelpResource[] fHelpResources;
    private String fText;

    public static void displayHelp(String contextId, CEditor editor) throws CoreException {
        String selected = CHelpDisplayContext.getSelectedString(editor);
        IContext context = HelpSystem.getContext((String)contextId);
        if (context != null) {
            if (selected != null && selected.length() > 0) {
                context = new CHelpDisplayContext(context, editor, selected);
            }
            PlatformUI.getWorkbench().getHelpSystem().displayHelp(context);
        }
    }

    private static String getSelectedString(CEditor editor) {
        String expression = null;
        try {
            ITextSelection selection = (ITextSelection)editor.getSite().getSelectionProvider().getSelection();
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IRegion region = CWordFinder.findWord(document, selection.getOffset());
            expression = document.get(region.getOffset(), region.getLength());
        }
        catch (Exception exception) {}
        return expression;
    }

    public CHelpDisplayContext(IContext context, final CEditor editor, String selected) throws CoreException {
        ICHelpResourceDescriptor[] providerResources;
        IHelpResource[] resources;
        ArrayList<IHelpResource> helpResources = new ArrayList<IHelpResource>();
        ICHelpInvocationContext invocationContext = new ICHelpInvocationContext(){

            public IProject getProject() {
                ITranslationUnit unit = this.getTranslationUnit();
                if (unit != null) {
                    return unit.getCProject().getProject();
                }
                return null;
            }

            public ITranslationUnit getTranslationUnit() {
                IEditorInput editorInput = editor.getEditorInput();
                return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput);
            }
        };
        if (context != null && (resources = context.getRelatedTopics()) != null) {
            helpResources.addAll(Arrays.asList(resources));
        }
        if ((providerResources = CHelpProviderManager.getDefault().getHelpResources(invocationContext, selected)) != null) {
            int i = 0;
            while (i < providerResources.length) {
                helpResources.addAll(Arrays.asList(providerResources[i].getHelpResources()));
                ++i;
            }
        }
        this.fHelpResources = helpResources.toArray(new IHelpResource[helpResources.size()]);
        if ((this.fText == null || this.fText.length() == 0) && context != null) {
            this.fText = context.getText();
        }
        if (this.fText != null && this.fText.length() == 0) {
            this.fText = null;
        }
    }

    private boolean doesNotExist(URL url) {
        if (url.getProtocol().equals("file")) {
            File file = new File(url.getFile());
            return !file.exists();
        }
        return false;
    }

    public IHelpResource[] getRelatedTopics() {
        return this.fHelpResources;
    }

    public String getText() {
        return this.fText;
    }
}

