/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;

public abstract class Parent
extends CElement {
    public Parent(ICElement parent, String name, int type) {
        super(parent, name, type);
    }

    public void addChild(ICElement member) throws CModelException {
        this.getElementInfo().addChild(member);
    }

    public void removeChild(ICElement member) throws CModelException {
        this.getElementInfo().removeChild(member);
    }

    public void removeChildren() throws CModelException {
        this.getElementInfo().removeChildren();
    }

    public ICElement[] getChildren() throws CModelException {
        CElementInfo info = this.getElementInfo();
        if (info != null) {
            return info.getChildren();
        }
        return CElement.NO_ELEMENTS;
    }

    public List getChildrenOfType(int type) throws CModelException {
        ICElement[] children = this.getChildren();
        int size = children.length;
        ArrayList<CElement> list = new ArrayList<CElement>(size);
        int i = 0;
        while (i < size) {
            CElement elt = (CElement)children[i];
            if (elt.getElementType() == type) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() {
        try {
            return this.getElementInfo().hasChildren();
        }
        catch (CModelException cModelException) {
            return false;
        }
    }

    protected void setChanged() {
        try {
            this.getElementInfo().setChanged();
        }
        catch (CModelException cModelException) {}
    }

    protected boolean hasChanged() {
        try {
            return this.getElementInfo().hasChanged();
        }
        catch (CModelException cModelException) {
            return false;
        }
    }
}

