/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ElementChangedEvent;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICElementDelta;
import org.eclipse.cdt.core.model.IElementChangedListener;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.BaseCElementContentProvider;
import org.eclipse.cdt.internal.ui.util.StringMatcher;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.DeferredTreeContentManager;

public class CContentOutlinerProvider
extends BaseCElementContentProvider {
    TreeViewer treeViewer;
    ITranslationUnit root;
    private ElementChangedListener fListener;
    private IPropertyChangeListener fPropertyListener;
    private StringMatcher filter = new StringMatcher("*", true, false);
    private DeferredTreeContentManager fManager;
    private boolean fUseContentManager = false;

    public CContentOutlinerProvider(TreeViewer viewer) {
        this(viewer, null);
    }

    public CContentOutlinerProvider(TreeViewer viewer, IWorkbenchPartSite site) {
        super(true, true);
        this.treeViewer = viewer;
        this.setIncludesGrouping(PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.cdt.ui.outline.groupincludes"));
        this.fManager = this.createContentManager(viewer, site);
    }

    protected DeferredTreeContentManager createContentManager(TreeViewer viewer, IWorkbenchPartSite site) {
        if (site == null) {
            return new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer);
        }
        return new DeferredTreeContentManager((ITreeContentProvider)this, (AbstractTreeViewer)viewer, site);
    }

    public void updateFilter(String newFilter) {
        this.filter = new StringMatcher(newFilter, true, false);
        this.contentUpdated();
    }

    public void contentUpdated() {
        if (this.treeViewer != null && !this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!CContentOutlinerProvider.this.treeViewer.getControl().isDisposed()) {
                        ISelection sel = CContentOutlinerProvider.this.treeViewer.getSelection();
                        CContentOutlinerProvider.this.treeViewer.setSelection(CContentOutlinerProvider.this.updateSelection(sel));
                        CContentOutlinerProvider.this.treeViewer.refresh();
                    }
                }
            });
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fListener != null) {
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
        }
        if (this.fPropertyListener != null) {
            PreferenceConstants.getPreferenceStore().removePropertyChangeListener(this.fPropertyListener);
            this.fPropertyListener = null;
        }
        if (this.root != null) {
            this.fManager.cancel((Object)this.root);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        boolean isTU = newInput instanceof ITranslationUnit;
        if (isTU && this.fListener == null) {
            this.fUseContentManager = true;
            if (this.root != null) {
                this.fManager.cancel((Object)this.root);
            }
            this.root = (ITranslationUnit)newInput;
            this.fListener = new ElementChangedListener();
            CoreModel.getDefault().addElementChangedListener((IElementChangedListener)this.fListener);
            this.fPropertyListener = new PropertyListener();
            PreferenceConstants.getPreferenceStore().addPropertyChangeListener(this.fPropertyListener);
        } else if (!isTU && this.fListener != null) {
            this.fUseContentManager = false;
            CoreModel.getDefault().removeElementChangedListener((IElementChangedListener)this.fListener);
            this.fListener = null;
            this.root = null;
            if (oldInput != null) {
                this.fManager.cancel(oldInput);
            }
        }
    }

    public Object[] getChildren(Object element) {
        Object[] children = null;
        if (this.fUseContentManager && element instanceof ITranslationUnit) {
            children = this.fManager.getChildren(element);
            this.fUseContentManager = false;
        }
        if (children == null) {
            children = super.getChildren(element);
        }
        ArrayList<Object> filtered = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            if (this.filter.match(children[i].toString())) {
                filtered.add(children[i]);
            }
            ++i;
        }
        int size = filtered.size();
        children = new Object[size];
        filtered.toArray(children);
        return children;
    }

    public boolean hasChildren(Object element) {
        if (this.fUseContentManager) {
            return this.fManager.mayHaveChildren(element);
        }
        return super.hasChildren(element);
    }

    protected ISelection updateSelection(ISelection sel) {
        ArrayList newSelection = new ArrayList();
        if (sel instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)sel).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof ICElement)) continue;
                newSelection.add(o);
            }
        }
        return new StructuredSelection(newSelection);
    }

    class ElementChangedListener
    implements IElementChangedListener {
        public void elementChanged(ElementChangedEvent e) {
            ICElementDelta delta = this.findElement((ICElement)CContentOutlinerProvider.this.root, e.getDelta());
            if (delta != null) {
                CContentOutlinerProvider.this.contentUpdated();
                return;
            }
        }

        private boolean isPossibleStructuralChange(ICElementDelta cuDelta) {
            int flags;
            boolean ret = cuDelta.getKind() != 4 ? true : (((flags = cuDelta.getFlags()) & 8) != 0 ? true : (flags & 0x400001) == 1);
            return ret;
        }

        protected ICElementDelta findElement(ICElement unit, ICElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            ICElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 60) {
                return null;
            }
            ICElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                ICElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }
    }

    class PropertyListener
    implements IPropertyChangeListener {
        PropertyListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            Object newValue;
            String prop = event.getProperty();
            if (prop.equals("org.eclipse.cdt.ui.outline.groupincludes")) {
                Object newValue2 = event.getNewValue();
                if (newValue2 instanceof Boolean) {
                    boolean value = (Boolean)newValue2;
                    if (CContentOutlinerProvider.this.areIncludesGroup() != value) {
                        CContentOutlinerProvider.this.setIncludesGrouping(value);
                        CContentOutlinerProvider.this.contentUpdated();
                    }
                }
            } else if (prop.equals("org.eclipse.cdt.ui.outline.groupnamespaces") && (newValue = event.getNewValue()) instanceof Boolean) {
                boolean value = (Boolean)newValue;
                if (CContentOutlinerProvider.this.areNamespacesGroup() != value) {
                    CContentOutlinerProvider.this.setNamespacesGrouping(value);
                    CContentOutlinerProvider.this.contentUpdated();
                }
            }
        }
    }
}

