/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.index.domsourceindexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.search.ICSearchConstants;
import org.eclipse.cdt.internal.core.Util;
import org.eclipse.cdt.internal.core.index.IIndexerOutput;
import org.eclipse.cdt.internal.core.index.IIndexerRunner;
import org.eclipse.cdt.internal.core.search.indexing.IndexManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractIndexerRunner
implements IIndexerRunner,
ICSearchConstants {
    public static boolean VERBOSE = false;
    public static boolean TIMING = false;
    protected IIndexerOutput output;
    private int problemMarkersEnabled = 0;
    private Map problemsMap = null;
    protected static final String INDEXER_MARKER_PREFIX = String.valueOf(Util.bind("indexerMarker.prefix")) + " ";
    protected static final String INDEXER_MARKER_ORIGINATOR = "org.eclipse.cdt.core.indexermarker.originator";
    private static final String INDEXER_MARKER_PROCESSING = Util.bind("indexerMarker.processing");
    protected IFile resourceFile;

    public static void verbose(String log) {
        System.out.println("(" + Thread.currentThread() + ") " + log);
    }

    public IIndexerOutput getOutput() {
        return this.output;
    }

    public Map getProblemsMap() {
        return this.problemsMap;
    }

    public void index(IFile file, IIndexerOutput output) throws IOException {
        this.output = output;
        if (this.shouldIndex(this.getResourceFile())) {
            this.indexFile(file);
        }
    }

    protected abstract void indexFile(IFile var1) throws IOException;

    public boolean shouldIndex(IFile fileToBeIndexed) {
        if (fileToBeIndexed != null) {
            String id = null;
            IContentType contentType = CCorePlugin.getContentType(fileToBeIndexed.getProject(), fileToBeIndexed.getName());
            if (contentType != null) {
                id = contentType.getId();
            }
            if (id != null) {
                if ("org.eclipse.cdt.core.cxxHeader".equals(id) || "org.eclipse.cdt.core.cxxSource".equals(id) || "org.eclipse.cdt.core.cHeader".equals(id) || "org.eclipse.cdt.core.cSource".equals(id)) {
                    return true;
                }
                "org.eclipse.cdt.core.asmSource".equals(id);
            }
        }
        return false;
    }

    protected void addInfoMarker(IFile tempFile, String message) {
        FileInfoMarker tempProblem = new FileInfoMarker((IResource)tempFile, (IResource)tempFile, message);
        if (this.getProblemsMap().containsKey(tempFile)) {
            List list = (List)this.getProblemsMap().get(tempFile);
            list.add(tempProblem);
        } else {
            ArrayList<Problem> list = new ArrayList<Problem>();
            list.add(new RemoveMarkerProblem(tempFile, this.getResourceFile()));
            list.add(tempProblem);
            this.getProblemsMap().put(tempFile, list);
        }
    }

    public boolean areProblemMarkersEnabled() {
        return this.problemMarkersEnabled != 0;
    }

    public int getProblemMarkersEnabled() {
        return this.problemMarkersEnabled;
    }

    public void setProblemMarkersEnabled(int value) {
        if (value != 0) {
            this.problemsMap = new HashMap();
        }
        this.problemMarkersEnabled = value;
    }

    public void requestRemoveMarkers(IFile resource, IFile originator) {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        RemoveMarkerProblem prob = new RemoveMarkerProblem(resource, originator);
        if (this.problemsMap.containsKey(resource)) {
            List list = (List)this.problemsMap.get(resource);
            list.clear();
            list.add(prob);
        } else {
            ArrayList<RemoveMarkerProblem> list = new ArrayList<RemoveMarkerProblem>();
            list.add(prob);
            this.problemsMap.put(resource, list);
        }
    }

    public void reportProblems() {
        if (!this.areProblemMarkersEnabled()) {
            return;
        }
        Iterator i = this.problemsMap.keySet().iterator();
        while (i.hasNext()) {
            IFile resource = (IFile)i.next();
            List problemList = (List)this.problemsMap.get(resource);
            if (problemList.size() <= 1) {
                IMarker[] marker;
                try {
                    marker = resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                }
                catch (CoreException coreException) {
                    continue;
                }
                if (marker.length == 0) continue;
            }
            String jobName = INDEXER_MARKER_PROCESSING;
            jobName = String.valueOf(jobName) + " (";
            jobName = String.valueOf(jobName) + resource.getFullPath();
            jobName = String.valueOf(jobName) + ')';
            ProcessMarkersJob job = new ProcessMarkersJob(resource, problemList, jobName);
            IndexManager indexManager = CCorePlugin.getDefault().getCoreModel().getIndexManager();
            IProgressMonitor group = indexManager.getIndexJobProgressGroup();
            job.setRule((ISchedulingRule)resource);
            if (group != null) {
                job.setProgressGroup(group, 0);
            }
            job.setPriority(50);
            job.schedule();
        }
    }

    protected void processMarkers(List problemsList) {
        Iterator i = problemsList.iterator();
        while (i.hasNext()) {
            Problem prob = (Problem)i.next();
            prob.run();
        }
    }

    public void run() {
    }

    public IFile getResourceFile() {
        return this.resourceFile;
    }

    protected abstract class Problem {
        public IResource resource;
        public IResource originator;

        public Problem(IResource resource, IResource originator) {
            this.resource = resource;
            this.originator = originator;
        }

        public abstract void run();
    }

    protected class FileInfoMarker
    extends Problem {
        private String message;

        public FileInfoMarker(IResource resource, IResource originator, String message) {
            super(resource, originator);
            this.message = message;
        }

        public void run() {
            try {
                IMarker[] markers = this.resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 0);
                boolean newProblem = true;
                if (markers.length > 0) {
                    IMarker tempMarker = null;
                    String tempMsgString = null;
                    int i = 0;
                    while (i < markers.length) {
                        tempMarker = markers[i];
                        tempMsgString = (String)tempMarker.getAttribute("message");
                        if (tempMsgString.equalsIgnoreCase(this.message)) {
                            newProblem = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (newProblem) {
                    IMarker marker = this.resource.createMarker("org.eclipse.cdt.core.indexermarker");
                    marker.setAttribute("message", (Object)this.message);
                    marker.setAttribute("severity", 0);
                    marker.setAttribute(AbstractIndexerRunner.INDEXER_MARKER_ORIGINATOR, (Object)this.originator.getFullPath().toString());
                }
            }
            catch (CoreException coreException) {}
        }
    }

    protected class RemoveMarkerProblem
    extends Problem {
        public RemoveMarkerProblem(IFile file, IFile orig) {
            super((IResource)file, (IResource)orig);
        }

        public void run() {
            IMarker[] markers;
            if (this.originator == null) {
                try {
                    this.resource.deleteMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
                }
                catch (CoreException coreException) {}
                return;
            }
            try {
                markers = this.resource.findMarkers("org.eclipse.cdt.core.indexermarker", true, 2);
            }
            catch (CoreException coreException) {
                return;
            }
            String origPath = this.originator.getFullPath().toString();
            IMarker mark = null;
            String orig = null;
            int i = 0;
            while (i < markers.length) {
                mark = markers[i];
                try {
                    orig = (String)mark.getAttribute(AbstractIndexerRunner.INDEXER_MARKER_ORIGINATOR);
                    if (orig != null) {
                        if (orig.equals(origPath)) {
                            mark.delete();
                        } else {
                            String id = null;
                            IContentType contentType = CCorePlugin.getContentType(this.resource.getProject(), orig);
                            if (contentType != null && ("org.eclipse.cdt.core.cxxHeader".equals(id = contentType.getId()) || "org.eclipse.cdt.core.cHeader".equals(id))) {
                                mark.delete();
                            }
                        }
                    }
                }
                catch (CoreException coreException) {}
                ++i;
            }
        }
    }

    private class ProcessMarkersJob
    extends Job {
        protected final List problems;
        private final IFile resource;

        public ProcessMarkersJob(IFile resource, List problems, String name) {
            super(name);
            this.problems = problems;
            this.resource = resource;
        }

        protected IStatus run(IProgressMonitor monitor) {
            IWorkspaceRunnable job = new IWorkspaceRunnable(this){
                final /* synthetic */ ProcessMarkersJob this$1;
                {
                    this.this$1 = processMarkersJob;
                }

                public void run(IProgressMonitor monitor) {
                    ProcessMarkersJob.access$0(this.this$1).processMarkers(this.this$1.problems);
                }
            };
            try {
                CCorePlugin.getWorkspace().run(job, (ISchedulingRule)this.resource, 0, null);
            }
            catch (CoreException coreException) {}
            return Status.OK_STATUS;
        }

        static /* synthetic */ AbstractIndexerRunner access$0(ProcessMarkersJob processMarkersJob) {
            return processMarkersJob.AbstractIndexerRunner.this;
        }
    }
}

