/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.cbrowsing;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cdt.internal.ui.actions.ActionMessages;
import org.eclipse.cdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.cdt.internal.ui.util.ExceptionHandler;
import org.eclipse.cdt.ui.CElementLabelProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.OpenResourceAction;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class OpenProjectAction
extends SelectionDispatchAction
implements IResourceChangeListener {
    private static final int EMPTY_SELECTION = 1;
    private static final int ELEMENT_SELECTION = 2;
    private int fMode;
    private OpenResourceAction fWorkbenchAction;

    public OpenProjectAction(IWorkbenchSite site) {
        super(site);
        this.fWorkbenchAction = new OpenResourceAction(site.getShell());
        this.setText(this.fWorkbenchAction.getText());
        this.setToolTipText(this.fWorkbenchAction.getToolTipText());
        this.setEnabled(this.hasCloseProjects());
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.cdt.ui.open_project_action");
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.fWorkbenchAction.resourceChanged(event);
        switch (this.fMode) {
            case 2: {
                this.setEnabled(this.fWorkbenchAction.isEnabled());
                break;
            }
            case 1: {
                this.internalResourceChanged(event);
            }
        }
    }

    private void internalResourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            IResourceDelta[] projDeltas = delta.getAffectedChildren(4);
            int i = 0;
            while (i < projDeltas.length) {
                IResourceDelta projDelta = projDeltas[i];
                if ((projDelta.getFlags() & 0x4000) != 0) {
                    this.setEnabled(this.hasCloseProjects());
                    return;
                }
                ++i;
            }
        }
    }

    public void selectionChanged(ISelection selection) {
        this.setEnabled(this.hasCloseProjects());
        this.fMode = 1;
    }

    public void run(ISelection selection) {
        this.internalRun();
    }

    public void selectionChanged(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.setEnabled(this.hasCloseProjects());
            this.fMode = 1;
            return;
        }
        this.fWorkbenchAction.selectionChanged(selection);
        this.setEnabled(this.fWorkbenchAction.isEnabled());
        this.fMode = 2;
    }

    public void run(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            this.internalRun();
            return;
        }
        this.fWorkbenchAction.run();
    }

    private void internalRun() {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new CElementLabelProvider());
        dialog.setTitle(ActionMessages.getString("OpenProjectAction.dialog.title"));
        dialog.setMessage(ActionMessages.getString("OpenProjectAction.dialog.message"));
        dialog.setElements(this.getClosedProjects());
        dialog.setMultipleSelection(true);
        int result = dialog.open();
        if (result != 0) {
            return;
        }
        Object[] projects = dialog.getResult();
        IWorkspaceRunnable runnable = this.createRunnable(projects);
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(runnable));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.getString("OpenProjectAction.dialog.title"), ActionMessages.getString("OpenProjectAction.error.message"));
        }
        catch (InterruptedException interruptedException) {}
    }

    private IWorkspaceRunnable createRunnable(final Object[] projects) {
        return new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", projects.length);
                MultiStatus errorStatus = null;
                int i = 0;
                while (i < projects.length) {
                    IProject project = (IProject)projects[i];
                    try {
                        project.open((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        if (errorStatus == null) {
                            errorStatus = new MultiStatus(CUIPlugin.getPluginId(), 4, ActionMessages.getString("OpenProjectAction.error.message"), (Throwable)e);
                        }
                        errorStatus.merge(e.getStatus());
                    }
                    ++i;
                }
                monitor.done();
                if (errorStatus != null) {
                    throw new CoreException(errorStatus);
                }
            }
        };
    }

    private Object[] getClosedProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>(5);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (!project.isOpen()) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray();
    }

    private boolean hasCloseProjects() {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (!projects[i].isOpen()) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

