/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs;

import org.eclipse.core.runtime.IStatus;

public class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public StatusInfo() {
        this(0, null);
    }

    public StatusInfo(int severity, String message) {
        this.fStatusMessage = message;
        this.fSeverity = severity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }

    public int getCode() {
        return this.fSeverity;
    }

    public Throwable getException() {
        return null;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public String getPlugin() {
        return "org.eclipse.cdt.core";
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public boolean isInfo() {
        return this.fSeverity == 1;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isWarning() {
        return this.fSeverity == 2;
    }

    public boolean matches(int severityMask) {
        return (this.fSeverity & severityMask) != 0;
    }

    public void setError(String errorMessage) {
        this.fStatusMessage = errorMessage;
        this.fSeverity = 4;
    }

    public void setInfo(String infoMessage) {
        this.fStatusMessage = infoMessage;
        this.fSeverity = 1;
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public void setWarning(String warningMessage) {
        this.fStatusMessage = warningMessage;
        this.fSeverity = 2;
    }
}

