/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.core;

import org.eclipse.cdt.make.core.IMakeBuilderInfo;
import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.MakeBuilder;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class MakeProjectNature
implements IProjectNature {
    public static final String NATURE_ID = String.valueOf(MakeCorePlugin.getUniqueIdentifier()) + ".makeNature";
    private IProject fProject;

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] prevNatures = description.getNatureIds();
        int i = 0;
        while (i < prevNatures.length) {
            if (NATURE_ID.equals(prevNatures[i])) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = NATURE_ID;
        description.setNatureIds(newNatures);
        project.setDescription(description, monitor);
    }

    public static ICommand getBuildSpec(IProjectDescription description, String builderID) {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    public static IProjectDescription setBuildSpec(IProjectDescription description, ICommand newCommand) {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldCommand = MakeProjectNature.getBuildSpec(description, newCommand.getBuilderName());
        if (oldCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i].getBuilderName().equals(oldCommand.getBuilderName())) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        return description;
    }

    public static void addToBuildSpec(IProject project, String builderID, IProgressMonitor mon) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            ICommand[] newCommands = new ICommand[commands.length + 1];
            System.arraycopy(commands, 0, newCommands, 1, commands.length);
            newCommands[0] = command;
            description.setBuildSpec(newCommands);
            project.setDescription(description, mon);
        }
    }

    public static void removeFromBuildSpec(IProject project, String builderID, IProgressMonitor mon) throws CoreException {
        IProjectDescription description = project.getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                break;
            }
            ++i;
        }
        project.setDescription(description, mon);
    }

    public void addBuildSpec() throws CoreException {
        MakeProjectNature.addToBuildSpec(this.getProject(), MakeBuilder.BUILDER_ID, null);
    }

    public void configure() throws CoreException {
        this.addBuildSpec();
        IMakeBuilderInfo info = MakeCorePlugin.createBuildInfo(MakeCorePlugin.getDefault().getPluginPreferences(), MakeBuilder.BUILDER_ID, false);
        IMakeBuilderInfo projectInfo = MakeCorePlugin.createBuildInfo(this.getProject(), MakeBuilder.BUILDER_ID);
        projectInfo.setBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, ""));
        projectInfo.setBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, info.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make"));
        projectInfo.setUseDefaultBuildCmd(info.isDefaultBuildCmd());
        projectInfo.setStopOnError(info.isStopOnError());
        projectInfo.setAutoBuildEnable(info.isAutoBuildEnable());
        projectInfo.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, info.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_AUTO, ""));
        projectInfo.setIncrementalBuildEnable(info.isIncrementalBuildEnabled());
        projectInfo.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREAMENTAL, info.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_INCREAMENTAL, ""));
        projectInfo.setFullBuildEnable(info.isFullBuildEnabled());
        projectInfo.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_FULL, info.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_FULL, ""));
        projectInfo.setCleanBuildEnable(info.isCleanBuildEnabled());
        projectInfo.setBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_CLEAN, info.getBuildAttribute(IMakeBuilderInfo.BUILD_TARGET_CLEAN, ""));
        projectInfo.setErrorParsers(info.getErrorParsers());
        projectInfo.setAppendEnvironment(info.appendEnvironment());
        projectInfo.setEnvironment(info.getEnvironment());
    }

    public void removeBuildSpec() throws CoreException {
        MakeProjectNature.removeFromBuildSpec(this.getProject(), MakeBuilder.BUILDER_ID, null);
    }

    public void deconfigure() throws CoreException {
        this.removeBuildSpec();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }
}

